<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTimeLimitType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Time Limit
 * @subpackage Structs
 */
class PaymentTimeLimitType extends AbstractStructBase
{
    /**
     * The PaymentTimeLimitDate
     * Meta information extracted from the WSDL
     * - documentation: A container for a payment time limit date.
     * - choice: PaymentTimeLimitDate | PaymentTimeLimitDuration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentTimeLimitDateType
     */
    public $PaymentTimeLimitDate;
    /**
     * The PaymentTimeLimitDuration
     * Meta information extracted from the WSDL
     * - documentation: A container for a payment time limit duration.
     * - choice: PaymentTimeLimitDate | PaymentTimeLimitDuration
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentTimeLimitDurationType
     */
    public $PaymentTimeLimitDuration;
    /**
     * Constructor method for PaymentTimeLimitType
     * @uses PaymentTimeLimitType::setPaymentTimeLimitDate()
     * @uses PaymentTimeLimitType::setPaymentTimeLimitDuration()
     * @param \StructType\PaymentTimeLimitDateType $paymentTimeLimitDate
     * @param \StructType\PaymentTimeLimitDurationType $paymentTimeLimitDuration
     */
    public function __construct(\StructType\PaymentTimeLimitDateType $paymentTimeLimitDate = null, \StructType\PaymentTimeLimitDurationType $paymentTimeLimitDuration = null)
    {
        $this
            ->setPaymentTimeLimitDate($paymentTimeLimitDate)
            ->setPaymentTimeLimitDuration($paymentTimeLimitDuration);
    }
    /**
     * Get PaymentTimeLimitDate value
     * @return \StructType\PaymentTimeLimitDateType
     */
    public function getPaymentTimeLimitDate()
    {
        return isset($this->PaymentTimeLimitDate) ? $this->PaymentTimeLimitDate : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentTimeLimitDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentTimeLimitDate method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentTimeLimitDateForChoiceConstraintsFromSetPaymentTimeLimitDate($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaymentTimeLimitDuration',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentTimeLimitDate can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentTimeLimitDate, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentTimeLimitDate value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentTimeLimitDateType $paymentTimeLimitDate
     * @return \StructType\PaymentTimeLimitType
     */
    public function setPaymentTimeLimitDate(\StructType\PaymentTimeLimitDateType $paymentTimeLimitDate = null)
    {
        // validation for constraint: choice(PaymentTimeLimitDate, PaymentTimeLimitDuration)
        if ('' !== ($paymentTimeLimitDateChoiceErrorMessage = self::validatePaymentTimeLimitDateForChoiceConstraintsFromSetPaymentTimeLimitDate($paymentTimeLimitDate))) {
            throw new \InvalidArgumentException($paymentTimeLimitDateChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentTimeLimitDate) || (is_array($paymentTimeLimitDate) && empty($paymentTimeLimitDate))) {
            unset($this->PaymentTimeLimitDate);
        } else {
            $this->PaymentTimeLimitDate = $paymentTimeLimitDate;
        }
        return $this;
    }
    /**
     * Get PaymentTimeLimitDuration value
     * @return \StructType\PaymentTimeLimitDurationType
     */
    public function getPaymentTimeLimitDuration()
    {
        return isset($this->PaymentTimeLimitDuration) ? $this->PaymentTimeLimitDuration : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaymentTimeLimitDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentTimeLimitDuration method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaymentTimeLimitDurationForChoiceConstraintsFromSetPaymentTimeLimitDuration($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaymentTimeLimitDate',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaymentTimeLimitDuration can\'t be set as the property %s is already set. Only one property must be set among these properties: PaymentTimeLimitDuration, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaymentTimeLimitDuration value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentTimeLimitDurationType $paymentTimeLimitDuration
     * @return \StructType\PaymentTimeLimitType
     */
    public function setPaymentTimeLimitDuration(\StructType\PaymentTimeLimitDurationType $paymentTimeLimitDuration = null)
    {
        // validation for constraint: choice(PaymentTimeLimitDate, PaymentTimeLimitDuration)
        if ('' !== ($paymentTimeLimitDurationChoiceErrorMessage = self::validatePaymentTimeLimitDurationForChoiceConstraintsFromSetPaymentTimeLimitDuration($paymentTimeLimitDuration))) {
            throw new \InvalidArgumentException($paymentTimeLimitDurationChoiceErrorMessage, __LINE__);
        }
        if (is_null($paymentTimeLimitDuration) || (is_array($paymentTimeLimitDuration) && empty($paymentTimeLimitDuration))) {
            unset($this->PaymentTimeLimitDuration);
        } else {
            $this->PaymentTimeLimitDuration = $paymentTimeLimitDuration;
        }
        return $this;
    }
}
