<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingIATA_EasyPayType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specialization for Payment Processing. IATA EasyPay is a payment instrument with a specific remittance mechanism. This FOP is not limited to BSP.
 * @subpackage Structs
 */
class PaymentProcessingIATA_EasyPayType extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: The 16 digit EasyPay account number. | Data type for Payment Card Number.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9X]{1,19}
     * @var string
     */
    public $AccountNumber;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: The last month of validity Example 0119. | BDT used to define card issue/expiry dates in a 4N format.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (0[1-9]|1[0-2])[0-9][0-9]
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IATA_EasyPayEncryptedData
     * Meta information extracted from the WSDL
     * - documentation: container for the encrypted Easy Pay data
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\IATA_EasyPayEncryptedDataType
     */
    public $IATA_EasyPayEncryptedData;
    /**
     * The IATA_Number
     * Meta information extracted from the WSDL
     * - documentation: IATA-assigned agency number. Example: 98417900 | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $IATA_Number;
    /**
     * Constructor method for PaymentProcessingIATA_EasyPayType
     * @uses PaymentProcessingIATA_EasyPayType::setAccountNumber()
     * @uses PaymentProcessingIATA_EasyPayType::setExpirationDate()
     * @uses PaymentProcessingIATA_EasyPayType::setIATA_EasyPayEncryptedData()
     * @uses PaymentProcessingIATA_EasyPayType::setIATA_Number()
     * @param string $accountNumber
     * @param string $expirationDate
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     * @param float $iATA_Number
     */
    public function __construct($accountNumber = null, $expirationDate = null, \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null, $iATA_Number = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setExpirationDate($expirationDate)
            ->setIATA_EasyPayEncryptedData($iATA_EasyPayEncryptedData)
            ->setIATA_Number($iATA_Number);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\PaymentProcessingIATA_EasyPayType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        // validation for constraint: pattern([0-9X]{1,19})
        if (!is_null($accountNumber) && !preg_match('/[0-9X]{1,19}/', $accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9X]{1,19}', var_export($accountNumber, true)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\PaymentProcessingIATA_EasyPayType
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        // validation for constraint: pattern((0[1-9]|1[0-2])[0-9][0-9])
        if (!is_null($expirationDate) && !preg_match('/(0[1-9]|1[0-2])[0-9][0-9]/', $expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression (0[1-9]|1[0-2])[0-9][0-9]', var_export($expirationDate, true)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get IATA_EasyPayEncryptedData value
     * @return \StructType\IATA_EasyPayEncryptedDataType|null
     */
    public function getIATA_EasyPayEncryptedData()
    {
        return $this->IATA_EasyPayEncryptedData;
    }
    /**
     * Set IATA_EasyPayEncryptedData value
     * @param \StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData
     * @return \StructType\PaymentProcessingIATA_EasyPayType
     */
    public function setIATA_EasyPayEncryptedData(\StructType\IATA_EasyPayEncryptedDataType $iATA_EasyPayEncryptedData = null)
    {
        $this->IATA_EasyPayEncryptedData = $iATA_EasyPayEncryptedData;
        return $this;
    }
    /**
     * Get IATA_Number value
     * @return float|null
     */
    public function getIATA_Number()
    {
        return $this->IATA_Number;
    }
    /**
     * Set IATA_Number value
     * @param float $iATA_Number
     * @return \StructType\PaymentProcessingIATA_EasyPayType
     */
    public function setIATA_Number($iATA_Number = null)
    {
        // validation for constraint: float
        if (!is_null($iATA_Number) && !(is_float($iATA_Number) || is_numeric($iATA_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($iATA_Number, true), gettype($iATA_Number)), __LINE__);
        }
        $this->IATA_Number = $iATA_Number;
        return $this;
    }
}
