<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to initiate a payment
 * @subpackage Structs
 */
class PaymentProcessingDetailsType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount applied to the associated payment method. Example: 300 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: Payment Processing Details Payment Method is a form of procedure for the payment of goods or services plus any transactional information specific to the payment method other than the amount.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentMethodType
     */
    public $PaymentMethod;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - documentation: Party committing to pay. In the case of a Credit or Debit Card this would be the Cardholder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayerType
     */
    public $Payer;
    /**
     * The PaymentProcessingClearanceData
     * Meta information extracted from the WSDL
     * - documentation: Clearance related data provided by the party committing the payment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingClearanceDataType
     */
    public $PaymentProcessingClearanceData;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRefID;
    /**
     * The PaymentSurchargeAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount added to the final Offer/Order price, depending on which payment method is used by the payer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PaymentSurchargeAmount;
    /**
     * The PriceVarianceAmount
     * Meta information extracted from the WSDL
     * - documentation: The tolerance level of the Seller should the new payment amount vary from the original payment amount. This tolerance is assumed to apply if new payment amount is lower than the original payment amount the Seller will tolerate.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PriceVarianceAmount;
    /**
     * Constructor method for PaymentProcessingDetailsType
     * @uses PaymentProcessingDetailsType::setAmount()
     * @uses PaymentProcessingDetailsType::setPaymentMethod()
     * @uses PaymentProcessingDetailsType::setPayer()
     * @uses PaymentProcessingDetailsType::setPaymentProcessingClearanceData()
     * @uses PaymentProcessingDetailsType::setPaymentRefID()
     * @uses PaymentProcessingDetailsType::setPaymentSurchargeAmount()
     * @uses PaymentProcessingDetailsType::setPriceVarianceAmount()
     * @param \StructType\AmountType $amount
     * @param \StructType\PaymentMethodType $paymentMethod
     * @param \StructType\PayerType $payer
     * @param \StructType\PaymentProcessingClearanceDataType $paymentProcessingClearanceData
     * @param string $paymentRefID
     * @param \StructType\AmountType $paymentSurchargeAmount
     * @param \StructType\AmountType $priceVarianceAmount
     */
    public function __construct(\StructType\AmountType $amount = null, \StructType\PaymentMethodType $paymentMethod = null, \StructType\PayerType $payer = null, \StructType\PaymentProcessingClearanceDataType $paymentProcessingClearanceData = null, $paymentRefID = null, \StructType\AmountType $paymentSurchargeAmount = null, \StructType\AmountType $priceVarianceAmount = null)
    {
        $this
            ->setAmount($amount)
            ->setPaymentMethod($paymentMethod)
            ->setPayer($payer)
            ->setPaymentProcessingClearanceData($paymentProcessingClearanceData)
            ->setPaymentRefID($paymentRefID)
            ->setPaymentSurchargeAmount($paymentSurchargeAmount)
            ->setPriceVarianceAmount($priceVarianceAmount);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return \StructType\PaymentMethodType
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param \StructType\PaymentMethodType $paymentMethod
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPaymentMethod(\StructType\PaymentMethodType $paymentMethod = null)
    {
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get Payer value
     * @return \StructType\PayerType|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \StructType\PayerType $payer
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPayer(\StructType\PayerType $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get PaymentProcessingClearanceData value
     * @return \StructType\PaymentProcessingClearanceDataType|null
     */
    public function getPaymentProcessingClearanceData()
    {
        return $this->PaymentProcessingClearanceData;
    }
    /**
     * Set PaymentProcessingClearanceData value
     * @param \StructType\PaymentProcessingClearanceDataType $paymentProcessingClearanceData
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPaymentProcessingClearanceData(\StructType\PaymentProcessingClearanceDataType $paymentProcessingClearanceData = null)
    {
        $this->PaymentProcessingClearanceData = $paymentProcessingClearanceData;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string|null
     */
    public function getPaymentRefID()
    {
        return $this->PaymentRefID;
    }
    /**
     * Set PaymentRefID value
     * @param string $paymentRefID
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPaymentRefID($paymentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRefID) && !is_string($paymentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRefID, true), gettype($paymentRefID)), __LINE__);
        }
        $this->PaymentRefID = $paymentRefID;
        return $this;
    }
    /**
     * Get PaymentSurchargeAmount value
     * @return \StructType\AmountType|null
     */
    public function getPaymentSurchargeAmount()
    {
        return $this->PaymentSurchargeAmount;
    }
    /**
     * Set PaymentSurchargeAmount value
     * @param \StructType\AmountType $paymentSurchargeAmount
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPaymentSurchargeAmount(\StructType\AmountType $paymentSurchargeAmount = null)
    {
        $this->PaymentSurchargeAmount = $paymentSurchargeAmount;
        return $this;
    }
    /**
     * Get PriceVarianceAmount value
     * @return \StructType\AmountType|null
     */
    public function getPriceVarianceAmount()
    {
        return $this->PriceVarianceAmount;
    }
    /**
     * Set PriceVarianceAmount value
     * @param \StructType\AmountType $priceVarianceAmount
     * @return \StructType\PaymentProcessingDetailsType
     */
    public function setPriceVarianceAmount(\StructType\AmountType $priceVarianceAmount = null)
    {
        $this->PriceVarianceAmount = $priceVarianceAmount;
        return $this;
    }
}
