<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingDeliveryResponseSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * @subpackage Structs
 */
class PaymentProcessingDeliveryResponseSummaryType extends AbstractStructBase
{
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Payer's Contact ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * The PaymentStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the current status of this payment information. | Enumeration values for payment status codes. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Status, coded{/codeListName}
     * {codeListIdentifier}PAYS{/codeListIdentifier} | Core statuses to be used across E&SD to express payment information required, refer to IATA code set PAYS
     * - base: PaymentStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatusCode;
    /**
     * Constructor method for PaymentProcessingDeliveryResponseSummaryType
     * @uses PaymentProcessingDeliveryResponseSummaryType::setContactInfoRefID()
     * @uses PaymentProcessingDeliveryResponseSummaryType::setDesc()
     * @uses PaymentProcessingDeliveryResponseSummaryType::setOrderItemRefID()
     * @uses PaymentProcessingDeliveryResponseSummaryType::setPaymentStatusCode()
     * @param string $contactInfoRefID
     * @param \StructType\DescType $desc
     * @param string[] $orderItemRefID
     * @param string $paymentStatusCode
     */
    public function __construct($contactInfoRefID = null, \StructType\DescType $desc = null, array $orderItemRefID = array(), $paymentStatusCode = null)
    {
        $this
            ->setContactInfoRefID($contactInfoRefID)
            ->setDesc($desc)
            ->setOrderItemRefID($orderItemRefID)
            ->setPaymentStatusCode($paymentStatusCode);
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string[]|null
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem)) {
                $invalidValues[] = is_object($paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem) ? get_class($paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem) : sprintf('%s(%s)', gettype($paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem), var_export($paymentProcessingDeliveryResponseSummaryTypeOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
    /**
     * Get PaymentStatusCode value
     * @return string|null
     */
    public function getPaymentStatusCode()
    {
        return $this->PaymentStatusCode;
    }
    /**
     * Set PaymentStatusCode value
     * @param string $paymentStatusCode
     * @return \StructType\PaymentProcessingDeliveryResponseSummaryType
     */
    public function setPaymentStatusCode($paymentStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusCode) && !is_string($paymentStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusCode, true), gettype($paymentStatusCode)), __LINE__);
        }
        $this->PaymentStatusCode = $paymentStatusCode;
        return $this;
    }
}
