<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProcessingDeliveryRequestSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Processing Delivery Response Summary Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * @subpackage Structs
 */
class PaymentProcessingDeliveryRequestSummaryType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount applied to the associated payment method. Example: 300 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The PaymentID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies payment information within a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentID;
    /**
     * The PaymentInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentInfoRefID;
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The payment method type. Examples: Credit Card, Cash. | The type code as in 'Credit card' used for a payment. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Type, coded{/codeListName}
     * {codeListIdentifier}PAYT{/codeListIdentifier} | Additional payment type codes for use in Enhanced and Simplified, refer to IATA code set PAYT
     * - base: PaymentTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Payer's Contact ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * The PaymentCommitmentDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date when the Payment including information about amount and payment method is accepted by ORA to be enough to lead to successful payment. | A date time identifies a date and time of day to various common resolutions: year,
     * month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCommitmentDateTime;
    /**
     * The PaymentInfoID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies payment information within a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInfoID;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRefID;
    /**
     * The PaymentStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the current status of this payment information. | Enumeration values for payment status codes. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Status, coded{/codeListName}
     * {codeListIdentifier}PAYS{/codeListIdentifier} | Core statuses to be used across E&SD to express payment information required, refer to IATA code set PAYS
     * - base: PaymentStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatusCode;
    /**
     * The PriceVarianceAmount
     * Meta information extracted from the WSDL
     * - documentation: Price variance amount applied during Payment processing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PriceVarianceAmount;
    /**
     * The SurchargeAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $SurchargeAmount;
    /**
     * The VerificationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this payment requires additional authentication. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $VerificationInd;
    /**
     * Constructor method for PaymentProcessingDeliveryRequestSummaryType
     * @uses PaymentProcessingDeliveryRequestSummaryType::setAmount()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentInfoRefID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentTypeCode()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setContactInfoRefID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setDesc()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setOrderItemRefID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentCommitmentDateTime()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentInfoID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentRefID()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPaymentStatusCode()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setPriceVarianceAmount()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setSurchargeAmount()
     * @uses PaymentProcessingDeliveryRequestSummaryType::setVerificationInd()
     * @param \StructType\AmountType $amount
     * @param string $paymentID
     * @param string $paymentInfoRefID
     * @param string $paymentTypeCode
     * @param string $contactInfoRefID
     * @param \StructType\DescType $desc
     * @param string[] $orderItemRefID
     * @param string $paymentCommitmentDateTime
     * @param string $paymentInfoID
     * @param string $paymentRefID
     * @param string $paymentStatusCode
     * @param \StructType\AmountType $priceVarianceAmount
     * @param \StructType\AmountType $surchargeAmount
     * @param bool $verificationInd
     */
    public function __construct(\StructType\AmountType $amount = null, $paymentID = null, $paymentInfoRefID = null, $paymentTypeCode = null, $contactInfoRefID = null, \StructType\DescType $desc = null, array $orderItemRefID = array(), $paymentCommitmentDateTime = null, $paymentInfoID = null, $paymentRefID = null, $paymentStatusCode = null, \StructType\AmountType $priceVarianceAmount = null, \StructType\AmountType $surchargeAmount = null, $verificationInd = null)
    {
        $this
            ->setAmount($amount)
            ->setPaymentID($paymentID)
            ->setPaymentInfoRefID($paymentInfoRefID)
            ->setPaymentTypeCode($paymentTypeCode)
            ->setContactInfoRefID($contactInfoRefID)
            ->setDesc($desc)
            ->setOrderItemRefID($orderItemRefID)
            ->setPaymentCommitmentDateTime($paymentCommitmentDateTime)
            ->setPaymentInfoID($paymentInfoID)
            ->setPaymentRefID($paymentRefID)
            ->setPaymentStatusCode($paymentStatusCode)
            ->setPriceVarianceAmount($priceVarianceAmount)
            ->setSurchargeAmount($surchargeAmount)
            ->setVerificationInd($verificationInd);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentID value
     * @return string
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param string $paymentID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentID) && !is_string($paymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentID, true), gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
    /**
     * Get PaymentInfoRefID value
     * @return string
     */
    public function getPaymentInfoRefID()
    {
        return $this->PaymentInfoRefID;
    }
    /**
     * Set PaymentInfoRefID value
     * @param string $paymentInfoRefID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentInfoRefID($paymentInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInfoRefID) && !is_string($paymentInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInfoRefID, true), gettype($paymentInfoRefID)), __LINE__);
        }
        $this->PaymentInfoRefID = $paymentInfoRefID;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string[]|null
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem)) {
                $invalidValues[] = is_object($paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem) ? get_class($paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem) : sprintf('%s(%s)', gettype($paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem), var_export($paymentProcessingDeliveryRequestSummaryTypeOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
    /**
     * Get PaymentCommitmentDateTime value
     * @return string|null
     */
    public function getPaymentCommitmentDateTime()
    {
        return $this->PaymentCommitmentDateTime;
    }
    /**
     * Set PaymentCommitmentDateTime value
     * @param string $paymentCommitmentDateTime
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentCommitmentDateTime($paymentCommitmentDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCommitmentDateTime) && !is_string($paymentCommitmentDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCommitmentDateTime, true), gettype($paymentCommitmentDateTime)), __LINE__);
        }
        $this->PaymentCommitmentDateTime = $paymentCommitmentDateTime;
        return $this;
    }
    /**
     * Get PaymentInfoID value
     * @return string|null
     */
    public function getPaymentInfoID()
    {
        return $this->PaymentInfoID;
    }
    /**
     * Set PaymentInfoID value
     * @param string $paymentInfoID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentInfoID($paymentInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInfoID) && !is_string($paymentInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInfoID, true), gettype($paymentInfoID)), __LINE__);
        }
        $this->PaymentInfoID = $paymentInfoID;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string|null
     */
    public function getPaymentRefID()
    {
        return $this->PaymentRefID;
    }
    /**
     * Set PaymentRefID value
     * @param string $paymentRefID
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentRefID($paymentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRefID) && !is_string($paymentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRefID, true), gettype($paymentRefID)), __LINE__);
        }
        $this->PaymentRefID = $paymentRefID;
        return $this;
    }
    /**
     * Get PaymentStatusCode value
     * @return string|null
     */
    public function getPaymentStatusCode()
    {
        return $this->PaymentStatusCode;
    }
    /**
     * Set PaymentStatusCode value
     * @param string $paymentStatusCode
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPaymentStatusCode($paymentStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusCode) && !is_string($paymentStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusCode, true), gettype($paymentStatusCode)), __LINE__);
        }
        $this->PaymentStatusCode = $paymentStatusCode;
        return $this;
    }
    /**
     * Get PriceVarianceAmount value
     * @return \StructType\AmountType|null
     */
    public function getPriceVarianceAmount()
    {
        return $this->PriceVarianceAmount;
    }
    /**
     * Set PriceVarianceAmount value
     * @param \StructType\AmountType $priceVarianceAmount
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setPriceVarianceAmount(\StructType\AmountType $priceVarianceAmount = null)
    {
        $this->PriceVarianceAmount = $priceVarianceAmount;
        return $this;
    }
    /**
     * Get SurchargeAmount value
     * @return \StructType\AmountType|null
     */
    public function getSurchargeAmount()
    {
        return $this->SurchargeAmount;
    }
    /**
     * Set SurchargeAmount value
     * @param \StructType\AmountType $surchargeAmount
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setSurchargeAmount(\StructType\AmountType $surchargeAmount = null)
    {
        $this->SurchargeAmount = $surchargeAmount;
        return $this;
    }
    /**
     * Get VerificationInd value
     * @return bool|null
     */
    public function getVerificationInd()
    {
        return $this->VerificationInd;
    }
    /**
     * Set VerificationInd value
     * @param bool $verificationInd
     * @return \StructType\PaymentProcessingDeliveryRequestSummaryType
     */
    public function setVerificationInd($verificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationInd) && !is_bool($verificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationInd, true), gettype($verificationInd)), __LINE__);
        }
        $this->VerificationInd = $verificationInd;
        return $this;
    }
}
