<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * @subpackage Structs
 */
class PaymentInfoType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount applied to the associated payment method. Example: 300 USD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The PaymentRefID
     * Meta information extracted from the WSDL
     * - documentation: If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again. | An identifier is a character string used to uniquely identify one instance
     * of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentRefID;
    /**
     * The PaymentTrx
     * Meta information extracted from the WSDL
     * - documentation: Additional identification and URLs used to further describe a secure payment transaction.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentTrxType
     */
    public $PaymentTrx;
    /**
     * The PaymentTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The payment method type. Examples: Credit Card, Cash. | The type code as in 'Credit card' used for a payment. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Type, coded{/codeListName}
     * {codeListIdentifier}PAYT{/codeListIdentifier} | Additional payment type codes for use in Enhanced and Simplified, refer to IATA code set PAYT
     * - base: PaymentTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * The AccountingPaymentMethod
     * Meta information extracted from the WSDL
     * - documentation: Payment Information Payment Method is a form of procedure for the payment of goods or services plus any transactional information specific to the payment method other than the amount.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AccountingPaymentMethodType
     */
    public $AccountingPaymentMethod;
    /**
     * The ClearanceData
     * Meta information extracted from the WSDL
     * - documentation: set of data, either signed or not, that delivers all that is necessary for a clearance of funds to take place when using the SwO Standard and Process. It supplies the data needed to execute the clearance using the SwO Standard and
     * Process. It is the core data required by the Clearance Manager to process a Clearance. Optionally, it can be agreed by the Clearance Payer and the Clearance Payee of the clearance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClearanceDataType
     */
    public $ClearanceData;
    /**
     * The ContactInfoRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Payer's Contact ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactInfoRefID;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order Item ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OrderItemRefID;
    /**
     * The OrderPaymentSummaryAllocation
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order or Order Items for which this payment method applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderAssociationType
     */
    public $OrderPaymentSummaryAllocation;
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order ID for this payment. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderRefID;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - documentation: Party committing to pay. In the case of a Credit or Debit Card this would be the Cardholder.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayerType
     */
    public $Payer;
    /**
     * The PaymentCommitmentDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date when the Payment including information about amount and payment method is accepted by ORA to be enough to lead to successful payment. | A date time identifies a date and time of day to various common resolutions: year,
     * month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCommitmentDateTime;
    /**
     * The PaymentInfoID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies payment information within a message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentInfoID;
    /**
     * The PaymentStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates the current status of this payment information. | Enumeration values for payment status codes. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Payment Status, coded{/codeListName}
     * {codeListIdentifier}PAYS{/codeListIdentifier} | Core statuses to be used across E&SD to express payment information required, refer to IATA code set PAYS
     * - base: PaymentStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatusCode;
    /**
     * The PriceVarianceAmount
     * Meta information extracted from the WSDL
     * - documentation: Price variance amount applied during Payment processing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PriceVarianceAmount;
    /**
     * The PriceVarianceRule
     * Meta information extracted from the WSDL
     * - documentation: Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceVarianceRuleType
     */
    public $PriceVarianceRule;
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionType[]
     */
    public $Promotion;
    /**
     * The SurchargeAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $SurchargeAmount;
    /**
     * The VerificationInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this payment requires additional authentication. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $VerificationInd;
    /**
     * Constructor method for PaymentInfoType
     * @uses PaymentInfoType::setAmount()
     * @uses PaymentInfoType::setPaymentRefID()
     * @uses PaymentInfoType::setPaymentTrx()
     * @uses PaymentInfoType::setPaymentTypeCode()
     * @uses PaymentInfoType::setAccountingPaymentMethod()
     * @uses PaymentInfoType::setClearanceData()
     * @uses PaymentInfoType::setContactInfoRefID()
     * @uses PaymentInfoType::setDesc()
     * @uses PaymentInfoType::setOrderItemRefID()
     * @uses PaymentInfoType::setOrderPaymentSummaryAllocation()
     * @uses PaymentInfoType::setOrderRefID()
     * @uses PaymentInfoType::setPayer()
     * @uses PaymentInfoType::setPaymentCommitmentDateTime()
     * @uses PaymentInfoType::setPaymentInfoID()
     * @uses PaymentInfoType::setPaymentStatusCode()
     * @uses PaymentInfoType::setPriceVarianceAmount()
     * @uses PaymentInfoType::setPriceVarianceRule()
     * @uses PaymentInfoType::setPromotion()
     * @uses PaymentInfoType::setSurchargeAmount()
     * @uses PaymentInfoType::setVerificationInd()
     * @param \StructType\AmountType $amount
     * @param string $paymentRefID
     * @param \StructType\PaymentTrxType $paymentTrx
     * @param string $paymentTypeCode
     * @param \StructType\AccountingPaymentMethodType $accountingPaymentMethod
     * @param \StructType\ClearanceDataType $clearanceData
     * @param string $contactInfoRefID
     * @param \StructType\DescType $desc
     * @param string[] $orderItemRefID
     * @param \StructType\OrderAssociationType $orderPaymentSummaryAllocation
     * @param string $orderRefID
     * @param \StructType\PayerType $payer
     * @param string $paymentCommitmentDateTime
     * @param string $paymentInfoID
     * @param string $paymentStatusCode
     * @param \StructType\AmountType $priceVarianceAmount
     * @param \StructType\PriceVarianceRuleType $priceVarianceRule
     * @param \StructType\PromotionType[] $promotion
     * @param \StructType\AmountType $surchargeAmount
     * @param bool $verificationInd
     */
    public function __construct(\StructType\AmountType $amount = null, $paymentRefID = null, \StructType\PaymentTrxType $paymentTrx = null, $paymentTypeCode = null, \StructType\AccountingPaymentMethodType $accountingPaymentMethod = null, \StructType\ClearanceDataType $clearanceData = null, $contactInfoRefID = null, \StructType\DescType $desc = null, array $orderItemRefID = array(), \StructType\OrderAssociationType $orderPaymentSummaryAllocation = null, $orderRefID = null, \StructType\PayerType $payer = null, $paymentCommitmentDateTime = null, $paymentInfoID = null, $paymentStatusCode = null, \StructType\AmountType $priceVarianceAmount = null, \StructType\PriceVarianceRuleType $priceVarianceRule = null, array $promotion = array(), \StructType\AmountType $surchargeAmount = null, $verificationInd = null)
    {
        $this
            ->setAmount($amount)
            ->setPaymentRefID($paymentRefID)
            ->setPaymentTrx($paymentTrx)
            ->setPaymentTypeCode($paymentTypeCode)
            ->setAccountingPaymentMethod($accountingPaymentMethod)
            ->setClearanceData($clearanceData)
            ->setContactInfoRefID($contactInfoRefID)
            ->setDesc($desc)
            ->setOrderItemRefID($orderItemRefID)
            ->setOrderPaymentSummaryAllocation($orderPaymentSummaryAllocation)
            ->setOrderRefID($orderRefID)
            ->setPayer($payer)
            ->setPaymentCommitmentDateTime($paymentCommitmentDateTime)
            ->setPaymentInfoID($paymentInfoID)
            ->setPaymentStatusCode($paymentStatusCode)
            ->setPriceVarianceAmount($priceVarianceAmount)
            ->setPriceVarianceRule($priceVarianceRule)
            ->setPromotion($promotion)
            ->setSurchargeAmount($surchargeAmount)
            ->setVerificationInd($verificationInd);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\PaymentInfoType
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentRefID value
     * @return string
     */
    public function getPaymentRefID()
    {
        return $this->PaymentRefID;
    }
    /**
     * Set PaymentRefID value
     * @param string $paymentRefID
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentRefID($paymentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRefID) && !is_string($paymentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRefID, true), gettype($paymentRefID)), __LINE__);
        }
        $this->PaymentRefID = $paymentRefID;
        return $this;
    }
    /**
     * Get PaymentTrx value
     * @return \StructType\PaymentTrxType
     */
    public function getPaymentTrx()
    {
        return $this->PaymentTrx;
    }
    /**
     * Set PaymentTrx value
     * @param \StructType\PaymentTrxType $paymentTrx
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentTrx(\StructType\PaymentTrxType $paymentTrx = null)
    {
        $this->PaymentTrx = $paymentTrx;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTypeCode, true), gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Get AccountingPaymentMethod value
     * @return \StructType\AccountingPaymentMethodType|null
     */
    public function getAccountingPaymentMethod()
    {
        return $this->AccountingPaymentMethod;
    }
    /**
     * Set AccountingPaymentMethod value
     * @param \StructType\AccountingPaymentMethodType $accountingPaymentMethod
     * @return \StructType\PaymentInfoType
     */
    public function setAccountingPaymentMethod(\StructType\AccountingPaymentMethodType $accountingPaymentMethod = null)
    {
        $this->AccountingPaymentMethod = $accountingPaymentMethod;
        return $this;
    }
    /**
     * Get ClearanceData value
     * @return \StructType\ClearanceDataType|null
     */
    public function getClearanceData()
    {
        return $this->ClearanceData;
    }
    /**
     * Set ClearanceData value
     * @param \StructType\ClearanceDataType $clearanceData
     * @return \StructType\PaymentInfoType
     */
    public function setClearanceData(\StructType\ClearanceDataType $clearanceData = null)
    {
        $this->ClearanceData = $clearanceData;
        return $this;
    }
    /**
     * Get ContactInfoRefID value
     * @return string|null
     */
    public function getContactInfoRefID()
    {
        return $this->ContactInfoRefID;
    }
    /**
     * Set ContactInfoRefID value
     * @param string $contactInfoRefID
     * @return \StructType\PaymentInfoType
     */
    public function setContactInfoRefID($contactInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($contactInfoRefID) && !is_string($contactInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactInfoRefID, true), gettype($contactInfoRefID)), __LINE__);
        }
        $this->ContactInfoRefID = $contactInfoRefID;
        return $this;
    }
    /**
     * Get Desc value
     * @return \StructType\DescType|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\PaymentInfoType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get OrderItemRefID value
     * @return string[]|null
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInfoTypeOrderItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($paymentInfoTypeOrderItemRefIDItem)) {
                $invalidValues[] = is_object($paymentInfoTypeOrderItemRefIDItem) ? get_class($paymentInfoTypeOrderItemRefIDItem) : sprintf('%s(%s)', gettype($paymentInfoTypeOrderItemRefIDItem), var_export($paymentInfoTypeOrderItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $orderItemRefID
     * @return \StructType\PaymentInfoType
     */
    public function setOrderItemRefID(array $orderItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemRefIDArrayErrorMessage = self::validateOrderItemRefIDForArrayConstraintsFromSetOrderItemRefID($orderItemRefID))) {
            throw new \InvalidArgumentException($orderItemRefIDArrayErrorMessage, __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Add item to OrderItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaymentInfoType
     */
    public function addToOrderItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OrderItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItemRefID[] = $item;
        return $this;
    }
    /**
     * Get OrderPaymentSummaryAllocation value
     * @return \StructType\OrderAssociationType|null
     */
    public function getOrderPaymentSummaryAllocation()
    {
        return $this->OrderPaymentSummaryAllocation;
    }
    /**
     * Set OrderPaymentSummaryAllocation value
     * @param \StructType\OrderAssociationType $orderPaymentSummaryAllocation
     * @return \StructType\PaymentInfoType
     */
    public function setOrderPaymentSummaryAllocation(\StructType\OrderAssociationType $orderPaymentSummaryAllocation = null)
    {
        $this->OrderPaymentSummaryAllocation = $orderPaymentSummaryAllocation;
        return $this;
    }
    /**
     * Get OrderRefID value
     * @return string|null
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\PaymentInfoType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
    /**
     * Get Payer value
     * @return \StructType\PayerType|null
     */
    public function getPayer()
    {
        return $this->Payer;
    }
    /**
     * Set Payer value
     * @param \StructType\PayerType $payer
     * @return \StructType\PaymentInfoType
     */
    public function setPayer(\StructType\PayerType $payer = null)
    {
        $this->Payer = $payer;
        return $this;
    }
    /**
     * Get PaymentCommitmentDateTime value
     * @return string|null
     */
    public function getPaymentCommitmentDateTime()
    {
        return $this->PaymentCommitmentDateTime;
    }
    /**
     * Set PaymentCommitmentDateTime value
     * @param string $paymentCommitmentDateTime
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentCommitmentDateTime($paymentCommitmentDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCommitmentDateTime) && !is_string($paymentCommitmentDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCommitmentDateTime, true), gettype($paymentCommitmentDateTime)), __LINE__);
        }
        $this->PaymentCommitmentDateTime = $paymentCommitmentDateTime;
        return $this;
    }
    /**
     * Get PaymentInfoID value
     * @return string|null
     */
    public function getPaymentInfoID()
    {
        return $this->PaymentInfoID;
    }
    /**
     * Set PaymentInfoID value
     * @param string $paymentInfoID
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentInfoID($paymentInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInfoID) && !is_string($paymentInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInfoID, true), gettype($paymentInfoID)), __LINE__);
        }
        $this->PaymentInfoID = $paymentInfoID;
        return $this;
    }
    /**
     * Get PaymentStatusCode value
     * @return string|null
     */
    public function getPaymentStatusCode()
    {
        return $this->PaymentStatusCode;
    }
    /**
     * Set PaymentStatusCode value
     * @param string $paymentStatusCode
     * @return \StructType\PaymentInfoType
     */
    public function setPaymentStatusCode($paymentStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusCode) && !is_string($paymentStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusCode, true), gettype($paymentStatusCode)), __LINE__);
        }
        $this->PaymentStatusCode = $paymentStatusCode;
        return $this;
    }
    /**
     * Get PriceVarianceAmount value
     * @return \StructType\AmountType|null
     */
    public function getPriceVarianceAmount()
    {
        return $this->PriceVarianceAmount;
    }
    /**
     * Set PriceVarianceAmount value
     * @param \StructType\AmountType $priceVarianceAmount
     * @return \StructType\PaymentInfoType
     */
    public function setPriceVarianceAmount(\StructType\AmountType $priceVarianceAmount = null)
    {
        $this->PriceVarianceAmount = $priceVarianceAmount;
        return $this;
    }
    /**
     * Get PriceVarianceRule value
     * @return \StructType\PriceVarianceRuleType|null
     */
    public function getPriceVarianceRule()
    {
        return $this->PriceVarianceRule;
    }
    /**
     * Set PriceVarianceRule value
     * @param \StructType\PriceVarianceRuleType $priceVarianceRule
     * @return \StructType\PaymentInfoType
     */
    public function setPriceVarianceRule(\StructType\PriceVarianceRuleType $priceVarianceRule = null)
    {
        $this->PriceVarianceRule = $priceVarianceRule;
        return $this;
    }
    /**
     * Get Promotion value
     * @return \StructType\PromotionType[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentInfoTypePromotionItem) {
            // validation for constraint: itemType
            if (!$paymentInfoTypePromotionItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($paymentInfoTypePromotionItem) ? get_class($paymentInfoTypePromotionItem) : sprintf('%s(%s)', gettype($paymentInfoTypePromotionItem), var_export($paymentInfoTypePromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotion
     * @return \StructType\PaymentInfoType
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\PaymentInfoType
     */
    public function addToPromotion(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Get SurchargeAmount value
     * @return \StructType\AmountType|null
     */
    public function getSurchargeAmount()
    {
        return $this->SurchargeAmount;
    }
    /**
     * Set SurchargeAmount value
     * @param \StructType\AmountType $surchargeAmount
     * @return \StructType\PaymentInfoType
     */
    public function setSurchargeAmount(\StructType\AmountType $surchargeAmount = null)
    {
        $this->SurchargeAmount = $surchargeAmount;
        return $this;
    }
    /**
     * Get VerificationInd value
     * @return bool|null
     */
    public function getVerificationInd()
    {
        return $this->VerificationInd;
    }
    /**
     * Set VerificationInd value
     * @param bool $verificationInd
     * @return \StructType\PaymentInfoType
     */
    public function setVerificationInd($verificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificationInd) && !is_bool($verificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verificationInd, true), gettype($verificationInd)), __LINE__);
        }
        $this->VerificationInd = $verificationInd;
        return $this;
    }
}
