<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFunctionsOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Is the container of all payment relevant functions.
 * @subpackage Structs
 */
class PaymentFunctionsOrderType extends AbstractStructBase
{
    /**
     * The OrderAssociation
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order or Order Items for which this payment method applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderAssociationType
     */
    public $OrderAssociation;
    /**
     * The OrderPaymentSummaryAllocation
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order or Order Items for which this payment method applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderAssociationType
     */
    public $OrderPaymentSummaryAllocation;
    /**
     * The PaymentProcessingSummary
     * Meta information extracted from the WSDL
     * - documentation: Information relating to a payment transaction including payment status.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentProcessingSummaryType
     */
    public $PaymentProcessingSummary;
    /**
     * The PaymentSupportedMethod
     * Meta information extracted from the WSDL
     * - documentation: Contains information relating to payment method acceptance. This always relates to the airlines payment acceptance terms regardless of preference expressed by a seller using PaymentCriteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentSupportedMethodType
     */
    public $PaymentSupportedMethod;
    /**
     * Constructor method for PaymentFunctionsOrderType
     * @uses PaymentFunctionsOrderType::setOrderAssociation()
     * @uses PaymentFunctionsOrderType::setOrderPaymentSummaryAllocation()
     * @uses PaymentFunctionsOrderType::setPaymentProcessingSummary()
     * @uses PaymentFunctionsOrderType::setPaymentSupportedMethod()
     * @param \StructType\OrderAssociationType $orderAssociation
     * @param \StructType\OrderAssociationType $orderPaymentSummaryAllocation
     * @param \StructType\PaymentProcessingSummaryType $paymentProcessingSummary
     * @param \StructType\PaymentSupportedMethodType $paymentSupportedMethod
     */
    public function __construct(\StructType\OrderAssociationType $orderAssociation = null, \StructType\OrderAssociationType $orderPaymentSummaryAllocation = null, \StructType\PaymentProcessingSummaryType $paymentProcessingSummary = null, \StructType\PaymentSupportedMethodType $paymentSupportedMethod = null)
    {
        $this
            ->setOrderAssociation($orderAssociation)
            ->setOrderPaymentSummaryAllocation($orderPaymentSummaryAllocation)
            ->setPaymentProcessingSummary($paymentProcessingSummary)
            ->setPaymentSupportedMethod($paymentSupportedMethod);
    }
    /**
     * Get OrderAssociation value
     * @return \StructType\OrderAssociationType|null
     */
    public function getOrderAssociation()
    {
        return $this->OrderAssociation;
    }
    /**
     * Set OrderAssociation value
     * @param \StructType\OrderAssociationType $orderAssociation
     * @return \StructType\PaymentFunctionsOrderType
     */
    public function setOrderAssociation(\StructType\OrderAssociationType $orderAssociation = null)
    {
        $this->OrderAssociation = $orderAssociation;
        return $this;
    }
    /**
     * Get OrderPaymentSummaryAllocation value
     * @return \StructType\OrderAssociationType|null
     */
    public function getOrderPaymentSummaryAllocation()
    {
        return $this->OrderPaymentSummaryAllocation;
    }
    /**
     * Set OrderPaymentSummaryAllocation value
     * @param \StructType\OrderAssociationType $orderPaymentSummaryAllocation
     * @return \StructType\PaymentFunctionsOrderType
     */
    public function setOrderPaymentSummaryAllocation(\StructType\OrderAssociationType $orderPaymentSummaryAllocation = null)
    {
        $this->OrderPaymentSummaryAllocation = $orderPaymentSummaryAllocation;
        return $this;
    }
    /**
     * Get PaymentProcessingSummary value
     * @return \StructType\PaymentProcessingSummaryType|null
     */
    public function getPaymentProcessingSummary()
    {
        return $this->PaymentProcessingSummary;
    }
    /**
     * Set PaymentProcessingSummary value
     * @param \StructType\PaymentProcessingSummaryType $paymentProcessingSummary
     * @return \StructType\PaymentFunctionsOrderType
     */
    public function setPaymentProcessingSummary(\StructType\PaymentProcessingSummaryType $paymentProcessingSummary = null)
    {
        $this->PaymentProcessingSummary = $paymentProcessingSummary;
        return $this;
    }
    /**
     * Get PaymentSupportedMethod value
     * @return \StructType\PaymentSupportedMethodType|null
     */
    public function getPaymentSupportedMethod()
    {
        return $this->PaymentSupportedMethod;
    }
    /**
     * Set PaymentSupportedMethod value
     * @param \StructType\PaymentSupportedMethodType $paymentSupportedMethod
     * @return \StructType\PaymentFunctionsOrderType
     */
    public function setPaymentSupportedMethod(\StructType\PaymentSupportedMethodType $paymentSupportedMethod = null)
    {
        $this->PaymentSupportedMethod = $paymentSupportedMethod;
        return $this;
    }
}
