<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFunctionsOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Is the container of all payment relevant functions.
 * @subpackage Structs
 */
class PaymentFunctionsOfferType extends AbstractStructBase
{
    /**
     * The OfferAssociation
     * Meta information extracted from the WSDL
     * - documentation: A set of associations to Offers and Offer Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferAssociationType[]
     */
    public $OfferAssociation;
    /**
     * The PaymentSupportedMethod
     * Meta information extracted from the WSDL
     * - documentation: Contains information relating to payment method acceptance. This always relates to the airlines payment acceptance terms regardless of preference expressed by a seller using PaymentCriteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentSupportedMethodType
     */
    public $PaymentSupportedMethod;
    /**
     * Constructor method for PaymentFunctionsOfferType
     * @uses PaymentFunctionsOfferType::setOfferAssociation()
     * @uses PaymentFunctionsOfferType::setPaymentSupportedMethod()
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @param \StructType\PaymentSupportedMethodType $paymentSupportedMethod
     */
    public function __construct(array $offerAssociation = array(), \StructType\PaymentSupportedMethodType $paymentSupportedMethod = null)
    {
        $this
            ->setOfferAssociation($offerAssociation)
            ->setPaymentSupportedMethod($paymentSupportedMethod);
    }
    /**
     * Get OfferAssociation value
     * @return \StructType\OfferAssociationType[]|null
     */
    public function getOfferAssociation()
    {
        return $this->OfferAssociation;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferAssociationForArrayConstraintsFromSetOfferAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentFunctionsOfferTypeOfferAssociationItem) {
            // validation for constraint: itemType
            if (!$paymentFunctionsOfferTypeOfferAssociationItem instanceof \StructType\OfferAssociationType) {
                $invalidValues[] = is_object($paymentFunctionsOfferTypeOfferAssociationItem) ? get_class($paymentFunctionsOfferTypeOfferAssociationItem) : sprintf('%s(%s)', gettype($paymentFunctionsOfferTypeOfferAssociationItem), var_export($paymentFunctionsOfferTypeOfferAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @return \StructType\PaymentFunctionsOfferType
     */
    public function setOfferAssociation(array $offerAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($offerAssociationArrayErrorMessage = self::validateOfferAssociationForArrayConstraintsFromSetOfferAssociation($offerAssociation))) {
            throw new \InvalidArgumentException($offerAssociationArrayErrorMessage, __LINE__);
        }
        $this->OfferAssociation = $offerAssociation;
        return $this;
    }
    /**
     * Add item to OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType $item
     * @return \StructType\PaymentFunctionsOfferType
     */
    public function addToOfferAssociation(\StructType\OfferAssociationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferAssociationType) {
            throw new \InvalidArgumentException(sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferAssociation[] = $item;
        return $this;
    }
    /**
     * Get PaymentSupportedMethod value
     * @return \StructType\PaymentSupportedMethodType|null
     */
    public function getPaymentSupportedMethod()
    {
        return $this->PaymentSupportedMethod;
    }
    /**
     * Set PaymentSupportedMethod value
     * @param \StructType\PaymentSupportedMethodType $paymentSupportedMethod
     * @return \StructType\PaymentFunctionsOfferType
     */
    public function setPaymentSupportedMethod(\StructType\PaymentSupportedMethodType $paymentSupportedMethod = null)
    {
        $this->PaymentSupportedMethod = $paymentSupportedMethod;
        return $this;
    }
}
