<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCriteriaAddlInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional Information relating to a given Payment Method Criteria
 * @subpackage Structs
 */
class PaymentCriteriaAddlInfoType extends AbstractStructBase
{
    /**
     * The PaymentCardCriteriaAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional Information relating to Payment Cards. For use with PaymentTypeCode(s) relating to Card forms of payment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentCardCriteriaAddlInfoType
     */
    public $PaymentCardCriteriaAddlInfo;
    /**
     * The PaymentOtherMethodAddlInfo
     * Meta information extracted from the WSDL
     * - documentation: Additional Information for other payment criteria. For use with PaymentTypeCode(s) relating to Other forms of payment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentOtherMethodAddlInfoType
     */
    public $PaymentOtherMethodAddlInfo;
    /**
     * Constructor method for PaymentCriteriaAddlInfoType
     * @uses PaymentCriteriaAddlInfoType::setPaymentCardCriteriaAddlInfo()
     * @uses PaymentCriteriaAddlInfoType::setPaymentOtherMethodAddlInfo()
     * @param \StructType\PaymentCardCriteriaAddlInfoType $paymentCardCriteriaAddlInfo
     * @param \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo
     */
    public function __construct(\StructType\PaymentCardCriteriaAddlInfoType $paymentCardCriteriaAddlInfo = null, \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo = null)
    {
        $this
            ->setPaymentCardCriteriaAddlInfo($paymentCardCriteriaAddlInfo)
            ->setPaymentOtherMethodAddlInfo($paymentOtherMethodAddlInfo);
    }
    /**
     * Get PaymentCardCriteriaAddlInfo value
     * @return \StructType\PaymentCardCriteriaAddlInfoType|null
     */
    public function getPaymentCardCriteriaAddlInfo()
    {
        return $this->PaymentCardCriteriaAddlInfo;
    }
    /**
     * Set PaymentCardCriteriaAddlInfo value
     * @param \StructType\PaymentCardCriteriaAddlInfoType $paymentCardCriteriaAddlInfo
     * @return \StructType\PaymentCriteriaAddlInfoType
     */
    public function setPaymentCardCriteriaAddlInfo(\StructType\PaymentCardCriteriaAddlInfoType $paymentCardCriteriaAddlInfo = null)
    {
        $this->PaymentCardCriteriaAddlInfo = $paymentCardCriteriaAddlInfo;
        return $this;
    }
    /**
     * Get PaymentOtherMethodAddlInfo value
     * @return \StructType\PaymentOtherMethodAddlInfoType|null
     */
    public function getPaymentOtherMethodAddlInfo()
    {
        return $this->PaymentOtherMethodAddlInfo;
    }
    /**
     * Set PaymentOtherMethodAddlInfo value
     * @param \StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo
     * @return \StructType\PaymentCriteriaAddlInfoType
     */
    public function setPaymentOtherMethodAddlInfo(\StructType\PaymentOtherMethodAddlInfoType $paymentOtherMethodAddlInfo = null)
    {
        $this->PaymentOtherMethodAddlInfo = $paymentOtherMethodAddlInfo;
        return $this;
    }
}
