<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAssociatedOfferFunctionsCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer Specialization of Payment Functions: Is the container of all payment relevant functions.
 * @subpackage Structs
 */
class PaymentAssociatedOfferFunctionsCriteriaType extends AbstractStructBase
{
    /**
     * The OfferAssociation
     * Meta information extracted from the WSDL
     * - documentation: A set of associations to Offers and Offer Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferAssociationType[]
     */
    public $OfferAssociation;
    /**
     * The PaymentMethodCriteria
     * Meta information extracted from the WSDL
     * - documentation: Contains information relating to payer preference. This could relate to the seller or the customer depending on the preference expressed within the container.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethodCriteriaType
     */
    public $PaymentMethodCriteria;
    /**
     * Constructor method for PaymentAssociatedOfferFunctionsCriteriaType
     * @uses PaymentAssociatedOfferFunctionsCriteriaType::setOfferAssociation()
     * @uses PaymentAssociatedOfferFunctionsCriteriaType::setPaymentMethodCriteria()
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @param \StructType\PaymentMethodCriteriaType $paymentMethodCriteria
     */
    public function __construct(array $offerAssociation = array(), \StructType\PaymentMethodCriteriaType $paymentMethodCriteria = null)
    {
        $this
            ->setOfferAssociation($offerAssociation)
            ->setPaymentMethodCriteria($paymentMethodCriteria);
    }
    /**
     * Get OfferAssociation value
     * @return \StructType\OfferAssociationType[]|null
     */
    public function getOfferAssociation()
    {
        return $this->OfferAssociation;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferAssociationForArrayConstraintsFromSetOfferAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem) {
            // validation for constraint: itemType
            if (!$paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem instanceof \StructType\OfferAssociationType) {
                $invalidValues[] = is_object($paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem) ? get_class($paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem) : sprintf('%s(%s)', gettype($paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem), var_export($paymentAssociatedOfferFunctionsCriteriaTypeOfferAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @return \StructType\PaymentAssociatedOfferFunctionsCriteriaType
     */
    public function setOfferAssociation(array $offerAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($offerAssociationArrayErrorMessage = self::validateOfferAssociationForArrayConstraintsFromSetOfferAssociation($offerAssociation))) {
            throw new \InvalidArgumentException($offerAssociationArrayErrorMessage, __LINE__);
        }
        $this->OfferAssociation = $offerAssociation;
        return $this;
    }
    /**
     * Add item to OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType $item
     * @return \StructType\PaymentAssociatedOfferFunctionsCriteriaType
     */
    public function addToOfferAssociation(\StructType\OfferAssociationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferAssociationType) {
            throw new \InvalidArgumentException(sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferAssociation[] = $item;
        return $this;
    }
    /**
     * Get PaymentMethodCriteria value
     * @return \StructType\PaymentMethodCriteriaType|null
     */
    public function getPaymentMethodCriteria()
    {
        return $this->PaymentMethodCriteria;
    }
    /**
     * Set PaymentMethodCriteria value
     * @param \StructType\PaymentMethodCriteriaType $paymentMethodCriteria
     * @return \StructType\PaymentAssociatedOfferFunctionsCriteriaType
     */
    public function setPaymentMethodCriteria(\StructType\PaymentMethodCriteriaType $paymentMethodCriteria = null)
    {
        $this->PaymentMethodCriteria = $paymentMethodCriteria;
        return $this;
    }
}
