<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAssociatedFunctionsCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Criteria Specialization of Payment Functions: Is the container of all payment relevant functions.
 * @subpackage Structs
 */
class PaymentAssociatedFunctionsCriteriaType extends AbstractStructBase
{
    /**
     * The OfferAssociation
     * Meta information extracted from the WSDL
     * - documentation: A set of associations to Offers and Offer Items.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferAssociationType[]
     */
    public $OfferAssociation;
    /**
     * The OrderAssociation
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order or Order Items for which this payment method applies.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderAssociationType
     */
    public $OrderAssociation;
    /**
     * The PaymentMethodCriteria
     * Meta information extracted from the WSDL
     * - documentation: Contains information relating to payer preference. This could relate to the seller or the customer depending on the preference expressed within the container.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethodCriteriaType
     */
    public $PaymentMethodCriteria;
    /**
     * The RefundMethodCriteria
     * Meta information extracted from the WSDL
     * - documentation: Contains information relating to refund preference. This could relate to the seller or the customer depending on the preference expressed within the container.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RefundMethodCriteriaType
     */
    public $RefundMethodCriteria;
    /**
     * Constructor method for PaymentAssociatedFunctionsCriteriaType
     * @uses PaymentAssociatedFunctionsCriteriaType::setOfferAssociation()
     * @uses PaymentAssociatedFunctionsCriteriaType::setOrderAssociation()
     * @uses PaymentAssociatedFunctionsCriteriaType::setPaymentMethodCriteria()
     * @uses PaymentAssociatedFunctionsCriteriaType::setRefundMethodCriteria()
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @param \StructType\OrderAssociationType $orderAssociation
     * @param \StructType\PaymentMethodCriteriaType $paymentMethodCriteria
     * @param \StructType\RefundMethodCriteriaType $refundMethodCriteria
     */
    public function __construct(array $offerAssociation = array(), \StructType\OrderAssociationType $orderAssociation = null, \StructType\PaymentMethodCriteriaType $paymentMethodCriteria = null, \StructType\RefundMethodCriteriaType $refundMethodCriteria = null)
    {
        $this
            ->setOfferAssociation($offerAssociation)
            ->setOrderAssociation($orderAssociation)
            ->setPaymentMethodCriteria($paymentMethodCriteria)
            ->setRefundMethodCriteria($refundMethodCriteria);
    }
    /**
     * Get OfferAssociation value
     * @return \StructType\OfferAssociationType[]|null
     */
    public function getOfferAssociation()
    {
        return $this->OfferAssociation;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferAssociationForArrayConstraintsFromSetOfferAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem) {
            // validation for constraint: itemType
            if (!$paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem instanceof \StructType\OfferAssociationType) {
                $invalidValues[] = is_object($paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem) ? get_class($paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem) : sprintf('%s(%s)', gettype($paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem), var_export($paymentAssociatedFunctionsCriteriaTypeOfferAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType[] $offerAssociation
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType
     */
    public function setOfferAssociation(array $offerAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($offerAssociationArrayErrorMessage = self::validateOfferAssociationForArrayConstraintsFromSetOfferAssociation($offerAssociation))) {
            throw new \InvalidArgumentException($offerAssociationArrayErrorMessage, __LINE__);
        }
        $this->OfferAssociation = $offerAssociation;
        return $this;
    }
    /**
     * Add item to OfferAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferAssociationType $item
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType
     */
    public function addToOfferAssociation(\StructType\OfferAssociationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferAssociationType) {
            throw new \InvalidArgumentException(sprintf('The OfferAssociation property can only contain items of type \StructType\OfferAssociationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferAssociation[] = $item;
        return $this;
    }
    /**
     * Get OrderAssociation value
     * @return \StructType\OrderAssociationType|null
     */
    public function getOrderAssociation()
    {
        return $this->OrderAssociation;
    }
    /**
     * Set OrderAssociation value
     * @param \StructType\OrderAssociationType $orderAssociation
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType
     */
    public function setOrderAssociation(\StructType\OrderAssociationType $orderAssociation = null)
    {
        $this->OrderAssociation = $orderAssociation;
        return $this;
    }
    /**
     * Get PaymentMethodCriteria value
     * @return \StructType\PaymentMethodCriteriaType|null
     */
    public function getPaymentMethodCriteria()
    {
        return $this->PaymentMethodCriteria;
    }
    /**
     * Set PaymentMethodCriteria value
     * @param \StructType\PaymentMethodCriteriaType $paymentMethodCriteria
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType
     */
    public function setPaymentMethodCriteria(\StructType\PaymentMethodCriteriaType $paymentMethodCriteria = null)
    {
        $this->PaymentMethodCriteria = $paymentMethodCriteria;
        return $this;
    }
    /**
     * Get RefundMethodCriteria value
     * @return \StructType\RefundMethodCriteriaType|null
     */
    public function getRefundMethodCriteria()
    {
        return $this->RefundMethodCriteria;
    }
    /**
     * Set RefundMethodCriteria value
     * @param \StructType\RefundMethodCriteriaType $refundMethodCriteria
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType
     */
    public function setRefundMethodCriteria(\StructType\RefundMethodCriteriaType $refundMethodCriteria = null)
    {
        $this->RefundMethodCriteria = $refundMethodCriteria;
        return $this;
    }
}
