<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAddressVerificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
 * @subpackage Structs
 */
class PaymentAddressVerificationType extends AbstractStructBase
{
    /**
     * The AddressVerificationInvalidInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the specified address was invalid. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AddressVerificationInvalidInd;
    /**
     * The AddressVerificationNoMatchInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the specified address could not be matched with issuing bank address on record. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AddressVerificationNoMatchInd;
    /**
     * The AddressVerificationStatusCode
     * Meta information extracted from the WSDL
     * - documentation: The address verification response code (AVS) when the ticketing agency performs address verification. Examples: X - Match: Street address and 9-digit ZIP code both match Y - Match: Street address and 5-digit ZIP code both match A -
     * Partial Match: Street address matches, but both 5-digit and 9-digit ZIP Code do not match W - Partial Match: Street address does not match, but 9-digit ZIP code matches Z - Partial Match: Street address does not match, but 5-digit ZIP code matches N
     * - No Match: Street address, 5-digit ZIP code, and 9-digit ZIP code all do not match U - System Unavailable: Address information unavailable. Returned if non-US. AVS is not available or if the AVS in a U.S. bank is not functioning properly. R - System
     * Unavailable: Retry - Issuer's System Unavailable or Timed Out. E - Invalid: AVS data is invalid S - Not Supported: U.S. issuing bank does not support AVS | A code is a character string of letters, numbers, special characters (except escape
     * sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressVerificationStatusCode;
    /**
     * The AddressVerificationText
     * Meta information extracted from the WSDL
     * - documentation: Additional Response Text from 3DS Provider. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressVerificationText;
    /**
     * Constructor method for PaymentAddressVerificationType
     * @uses PaymentAddressVerificationType::setAddressVerificationInvalidInd()
     * @uses PaymentAddressVerificationType::setAddressVerificationNoMatchInd()
     * @uses PaymentAddressVerificationType::setAddressVerificationStatusCode()
     * @uses PaymentAddressVerificationType::setAddressVerificationText()
     * @param bool $addressVerificationInvalidInd
     * @param bool $addressVerificationNoMatchInd
     * @param string $addressVerificationStatusCode
     * @param string $addressVerificationText
     */
    public function __construct($addressVerificationInvalidInd = null, $addressVerificationNoMatchInd = null, $addressVerificationStatusCode = null, $addressVerificationText = null)
    {
        $this
            ->setAddressVerificationInvalidInd($addressVerificationInvalidInd)
            ->setAddressVerificationNoMatchInd($addressVerificationNoMatchInd)
            ->setAddressVerificationStatusCode($addressVerificationStatusCode)
            ->setAddressVerificationText($addressVerificationText);
    }
    /**
     * Get AddressVerificationInvalidInd value
     * @return bool|null
     */
    public function getAddressVerificationInvalidInd()
    {
        return $this->AddressVerificationInvalidInd;
    }
    /**
     * Set AddressVerificationInvalidInd value
     * @param bool $addressVerificationInvalidInd
     * @return \StructType\PaymentAddressVerificationType
     */
    public function setAddressVerificationInvalidInd($addressVerificationInvalidInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressVerificationInvalidInd) && !is_bool($addressVerificationInvalidInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressVerificationInvalidInd, true), gettype($addressVerificationInvalidInd)), __LINE__);
        }
        $this->AddressVerificationInvalidInd = $addressVerificationInvalidInd;
        return $this;
    }
    /**
     * Get AddressVerificationNoMatchInd value
     * @return bool|null
     */
    public function getAddressVerificationNoMatchInd()
    {
        return $this->AddressVerificationNoMatchInd;
    }
    /**
     * Set AddressVerificationNoMatchInd value
     * @param bool $addressVerificationNoMatchInd
     * @return \StructType\PaymentAddressVerificationType
     */
    public function setAddressVerificationNoMatchInd($addressVerificationNoMatchInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressVerificationNoMatchInd) && !is_bool($addressVerificationNoMatchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressVerificationNoMatchInd, true), gettype($addressVerificationNoMatchInd)), __LINE__);
        }
        $this->AddressVerificationNoMatchInd = $addressVerificationNoMatchInd;
        return $this;
    }
    /**
     * Get AddressVerificationStatusCode value
     * @return string|null
     */
    public function getAddressVerificationStatusCode()
    {
        return $this->AddressVerificationStatusCode;
    }
    /**
     * Set AddressVerificationStatusCode value
     * @param string $addressVerificationStatusCode
     * @return \StructType\PaymentAddressVerificationType
     */
    public function setAddressVerificationStatusCode($addressVerificationStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($addressVerificationStatusCode) && !is_string($addressVerificationStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressVerificationStatusCode, true), gettype($addressVerificationStatusCode)), __LINE__);
        }
        $this->AddressVerificationStatusCode = $addressVerificationStatusCode;
        return $this;
    }
    /**
     * Get AddressVerificationText value
     * @return string|null
     */
    public function getAddressVerificationText()
    {
        return $this->AddressVerificationText;
    }
    /**
     * Set AddressVerificationText value
     * @param string $addressVerificationText
     * @return \StructType\PaymentAddressVerificationType
     */
    public function setAddressVerificationText($addressVerificationText = null)
    {
        // validation for constraint: string
        if (!is_null($addressVerificationText) && !is_string($addressVerificationText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressVerificationText, true), gettype($addressVerificationText)), __LINE__);
        }
        $this->AddressVerificationText = $addressVerificationText;
        return $this;
    }
}
