<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayerType StructType
 * Meta information extracted from the WSDL
 * - documentation: Party committing to pay. In the case of a Credit or Debit Card this would be the Cardholder.
 * @subpackage Structs
 */
class PayerType extends AbstractStructBase
{
    /**
     * The PayerEmailAddress
     * Meta information extracted from the WSDL
     * - documentation: The email address which should be used for contact purposes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmailAddressType
     */
    public $PayerEmailAddress;
    /**
     * The PayerName
     * Meta information extracted from the WSDL
     * - documentation: Payer Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PayerNameType
     */
    public $PayerName;
    /**
     * The PayerPhoneNumber
     * Meta information extracted from the WSDL
     * - documentation: A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other
     * devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PhoneType
     */
    public $PayerPhoneNumber;
    /**
     * The PaymentAddress
     * Meta information extracted from the WSDL
     * - documentation: A physical address that is associated with payment types , This comprises of a postal address and optional payment verification.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentAddressType
     */
    public $PaymentAddress;
    /**
     * Constructor method for PayerType
     * @uses PayerType::setPayerEmailAddress()
     * @uses PayerType::setPayerName()
     * @uses PayerType::setPayerPhoneNumber()
     * @uses PayerType::setPaymentAddress()
     * @param \StructType\EmailAddressType $payerEmailAddress
     * @param \StructType\PayerNameType $payerName
     * @param \StructType\PhoneType $payerPhoneNumber
     * @param \StructType\PaymentAddressType $paymentAddress
     */
    public function __construct(\StructType\EmailAddressType $payerEmailAddress = null, \StructType\PayerNameType $payerName = null, \StructType\PhoneType $payerPhoneNumber = null, \StructType\PaymentAddressType $paymentAddress = null)
    {
        $this
            ->setPayerEmailAddress($payerEmailAddress)
            ->setPayerName($payerName)
            ->setPayerPhoneNumber($payerPhoneNumber)
            ->setPaymentAddress($paymentAddress);
    }
    /**
     * Get PayerEmailAddress value
     * @return \StructType\EmailAddressType|null
     */
    public function getPayerEmailAddress()
    {
        return $this->PayerEmailAddress;
    }
    /**
     * Set PayerEmailAddress value
     * @param \StructType\EmailAddressType $payerEmailAddress
     * @return \StructType\PayerType
     */
    public function setPayerEmailAddress(\StructType\EmailAddressType $payerEmailAddress = null)
    {
        $this->PayerEmailAddress = $payerEmailAddress;
        return $this;
    }
    /**
     * Get PayerName value
     * @return \StructType\PayerNameType|null
     */
    public function getPayerName()
    {
        return $this->PayerName;
    }
    /**
     * Set PayerName value
     * @param \StructType\PayerNameType $payerName
     * @return \StructType\PayerType
     */
    public function setPayerName(\StructType\PayerNameType $payerName = null)
    {
        $this->PayerName = $payerName;
        return $this;
    }
    /**
     * Get PayerPhoneNumber value
     * @return \StructType\PhoneType|null
     */
    public function getPayerPhoneNumber()
    {
        return $this->PayerPhoneNumber;
    }
    /**
     * Set PayerPhoneNumber value
     * @param \StructType\PhoneType $payerPhoneNumber
     * @return \StructType\PayerType
     */
    public function setPayerPhoneNumber(\StructType\PhoneType $payerPhoneNumber = null)
    {
        $this->PayerPhoneNumber = $payerPhoneNumber;
        return $this;
    }
    /**
     * Get PaymentAddress value
     * @return \StructType\PaymentAddressType|null
     */
    public function getPaymentAddress()
    {
        return $this->PaymentAddress;
    }
    /**
     * Set PaymentAddress value
     * @param \StructType\PaymentAddressType $paymentAddress
     * @return \StructType\PayerType
     */
    public function setPaymentAddress(\StructType\PaymentAddressType $paymentAddress = null)
    {
        $this->PaymentAddress = $paymentAddress;
        return $this;
    }
}
