<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxNameChangeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Echos back the name changes allowed by the Airline, packaged within an OfferItem.
 * @subpackage Structs
 */
class PaxNameChangeType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: References the Passenger ID for which this name change is applicable. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Individual's hereditary name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix. | BDT with value constraints for proper, regular names (e.g. Individual Surname,
     * Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Surname;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: A personal name given to the individual at birth and used before a family name. Also called first name. E.g. JOHN. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name,
     * etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Individual's middle name or initial. E.g. G, GEORGE. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SuffixName
     * Meta information extracted from the WSDL
     * - documentation: Individual's name suffixes and letters. Examples: Jr., Sr., III, Ret., Esq. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuffixName;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: A word such as Mr., Mrs., Miss or Dr that is used before an individual's name to indicate the gender, profession or marital status. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleName;
    /**
     * Constructor method for PaxNameChangeType
     * @uses PaxNameChangeType::setPaxRefID()
     * @uses PaxNameChangeType::setSurname()
     * @uses PaxNameChangeType::setGivenName()
     * @uses PaxNameChangeType::setMiddleName()
     * @uses PaxNameChangeType::setSuffixName()
     * @uses PaxNameChangeType::setTitleName()
     * @param string $paxRefID
     * @param string $surname
     * @param string[] $givenName
     * @param string[] $middleName
     * @param string $suffixName
     * @param string $titleName
     */
    public function __construct($paxRefID = null, $surname = null, array $givenName = array(), array $middleName = array(), $suffixName = null, $titleName = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setSurname($surname)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setSuffixName($suffixName)
            ->setTitleName($titleName);
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\PaxNameChangeType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get Surname value
     * @return string
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\PaxNameChangeType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($surname) && mb_strlen($surname) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surname) && mb_strlen($surname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($paxNameChangeTypeGivenNameItem)) {
                $invalidValues[] = is_object($paxNameChangeTypeGivenNameItem) ? get_class($paxNameChangeTypeGivenNameItem) : sprintf('%s(%s)', gettype($paxNameChangeTypeGivenNameItem), var_export($paxNameChangeTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMaxLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeGivenNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($paxNameChangeTypeGivenNameItem) > 64) {
                $invalidValues[] = var_export($paxNameChangeTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMinLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeGivenNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($paxNameChangeTypeGivenNameItem) < 1) {
                $invalidValues[] = var_export($paxNameChangeTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \StructType\PaxNameChangeType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($givenNameMaxLengthErrorMessage = self::validateGivenNameForMaxLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($givenNameMinLengthErrorMessage = self::validateGivenNameForMinLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMinLengthErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaxNameChangeType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($paxNameChangeTypeMiddleNameItem)) {
                $invalidValues[] = is_object($paxNameChangeTypeMiddleNameItem) ? get_class($paxNameChangeTypeMiddleNameItem) : sprintf('%s(%s)', gettype($paxNameChangeTypeMiddleNameItem), var_export($paxNameChangeTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMaxLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeMiddleNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($paxNameChangeTypeMiddleNameItem) > 64) {
                $invalidValues[] = var_export($paxNameChangeTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMinLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxNameChangeTypeMiddleNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($paxNameChangeTypeMiddleNameItem) < 1) {
                $invalidValues[] = var_export($paxNameChangeTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \StructType\PaxNameChangeType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($middleNameMaxLengthErrorMessage = self::validateMiddleNameForMaxLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($middleNameMinLengthErrorMessage = self::validateMiddleNameForMinLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMinLengthErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaxNameChangeType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SuffixName value
     * @return string|null
     */
    public function getSuffixName()
    {
        return $this->SuffixName;
    }
    /**
     * Set SuffixName value
     * @param string $suffixName
     * @return \StructType\PaxNameChangeType
     */
    public function setSuffixName($suffixName = null)
    {
        // validation for constraint: string
        if (!is_null($suffixName) && !is_string($suffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixName, true), gettype($suffixName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($suffixName) && mb_strlen($suffixName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($suffixName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($suffixName) && mb_strlen($suffixName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($suffixName)), __LINE__);
        }
        $this->SuffixName = $suffixName;
        return $this;
    }
    /**
     * Get TitleName value
     * @return string|null
     */
    public function getTitleName()
    {
        return $this->TitleName;
    }
    /**
     * Set TitleName value
     * @param string $titleName
     * @return \StructType\PaxNameChangeType
     */
    public function setTitleName($titleName = null)
    {
        // validation for constraint: string
        if (!is_null($titleName) && !is_string($titleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleName, true), gettype($titleName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($titleName) && mb_strlen($titleName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($titleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titleName) && mb_strlen($titleName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titleName)), __LINE__);
        }
        $this->TitleName = $titleName;
        return $this;
    }
}
