<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaxListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Passenger data list definition.
 * @subpackage Structs
 */
class PaxListType extends AbstractStructBase
{
    /**
     * The Pax
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\PaxType[]
     */
    public $Pax;
    /**
     * Constructor method for PaxListType
     * @uses PaxListType::setPax()
     * @param \StructType\PaxType[] $pax
     */
    public function __construct(array $pax = array())
    {
        $this
            ->setPax($pax);
    }
    /**
     * Get Pax value
     * @return \StructType\PaxType[]
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * This method is responsible for validating the values passed to the setPax method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPax method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxForArrayConstraintsFromSetPax(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paxListTypePaxItem) {
            // validation for constraint: itemType
            if (!$paxListTypePaxItem instanceof \StructType\PaxType) {
                $invalidValues[] = is_object($paxListTypePaxItem) ? get_class($paxListTypePaxItem) : sprintf('%s(%s)', gettype($paxListTypePaxItem), var_export($paxListTypePaxItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType[] $pax
     * @return \StructType\PaxListType
     */
    public function setPax(array $pax = array())
    {
        // validation for constraint: array
        if ('' !== ($paxArrayErrorMessage = self::validatePaxForArrayConstraintsFromSetPax($pax))) {
            throw new \InvalidArgumentException($paxArrayErrorMessage, __LINE__);
        }
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Add item to Pax value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType $item
     * @return \StructType\PaxListType
     */
    public function addToPax(\StructType\PaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxType) {
            throw new \InvalidArgumentException(sprintf('The Pax property can only contain items of type \StructType\PaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pax[] = $item;
        return $this;
    }
}
