<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Information identifying the location and other attributes of the entity performing transactions. Point of sale may be considered by some systems when making inventory and availability decisions.
 * @subpackage Structs
 */
class POS_Type extends AbstractStructBase
{
    /**
     * The AgentDutyText
     * Meta information extracted from the WSDL
     * - documentation: Internally defined agent authority to request changes. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentDutyText;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address, or metropolitan area)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CityType
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: A nation with its own government, occupying a particular territory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Country;
    /**
     * The OnlineTrxInd
     * Meta information extracted from the WSDL
     * - documentation: Indicator to flag if this is an online transaction. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $OnlineTrxInd;
    /**
     * The RequestTime
     * Meta information extracted from the WSDL
     * - documentation: Point of sale timestamp value. Example: 2017-01-13T13:59:38Z Note: This may be used if the point of sale time zone differs from the message creation timestamp. | A date time identifies a date and time of day to various common
     * resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestTime;
    /**
     * Constructor method for POS_Type
     * @uses POS_Type::setAgentDutyText()
     * @uses POS_Type::setCity()
     * @uses POS_Type::setCountry()
     * @uses POS_Type::setOnlineTrxInd()
     * @uses POS_Type::setRequestTime()
     * @param string $agentDutyText
     * @param \StructType\CityType $city
     * @param \StructType\CountryType $country
     * @param bool $onlineTrxInd
     * @param string $requestTime
     */
    public function __construct($agentDutyText = null, \StructType\CityType $city = null, \StructType\CountryType $country = null, $onlineTrxInd = null, $requestTime = null)
    {
        $this
            ->setAgentDutyText($agentDutyText)
            ->setCity($city)
            ->setCountry($country)
            ->setOnlineTrxInd($onlineTrxInd)
            ->setRequestTime($requestTime);
    }
    /**
     * Get AgentDutyText value
     * @return string|null
     */
    public function getAgentDutyText()
    {
        return $this->AgentDutyText;
    }
    /**
     * Set AgentDutyText value
     * @param string $agentDutyText
     * @return \StructType\POS_Type
     */
    public function setAgentDutyText($agentDutyText = null)
    {
        // validation for constraint: string
        if (!is_null($agentDutyText) && !is_string($agentDutyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentDutyText, true), gettype($agentDutyText)), __LINE__);
        }
        $this->AgentDutyText = $agentDutyText;
        return $this;
    }
    /**
     * Get City value
     * @return \StructType\CityType|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \StructType\CityType $city
     * @return \StructType\POS_Type
     */
    public function setCity(\StructType\CityType $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryType $country
     * @return \StructType\POS_Type
     */
    public function setCountry(\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get OnlineTrxInd value
     * @return bool|null
     */
    public function getOnlineTrxInd()
    {
        return $this->OnlineTrxInd;
    }
    /**
     * Set OnlineTrxInd value
     * @param bool $onlineTrxInd
     * @return \StructType\POS_Type
     */
    public function setOnlineTrxInd($onlineTrxInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlineTrxInd) && !is_bool($onlineTrxInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlineTrxInd, true), gettype($onlineTrxInd)), __LINE__);
        }
        $this->OnlineTrxInd = $onlineTrxInd;
        return $this;
    }
    /**
     * Get RequestTime value
     * @return string|null
     */
    public function getRequestTime()
    {
        return $this->RequestTime;
    }
    /**
     * Set RequestTime value
     * @param string $requestTime
     * @return \StructType\POS_Type
     */
    public function setRequestTime($requestTime = null)
    {
        // validation for constraint: string
        if (!is_null($requestTime) && !is_string($requestTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTime, true), gettype($requestTime)), __LINE__);
        }
        $this->RequestTime = $requestTime;
        return $this;
    }
}
