<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for POS_FilterCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Criteria used to filter results based on point of sale information.
 * @subpackage Structs
 */
class POS_FilterCriteriaType extends AbstractStructBase
{
    /**
     * The POS_TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Further defines the types of Point of Sale | Further defines the type of PointOfSaleCode.
     * - base: POS_TypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $POS_TypeCode;
    /**
     * The TravelAgencyInd
     * Meta information extracted from the WSDL
     * - documentation: Unique Agency Seller ID. Example: CTRV | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TravelAgencyInd;
    /**
     * The Aggregator
     * Meta information extracted from the WSDL
     * - documentation: An entity who distributes a Seller's shopping request to multiple Airlines and aggregates subsequent responses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AggregatorType
     */
    public $Aggregator;
    /**
     * The POS_CodeText
     * Meta information extracted from the WSDL
     * - documentation: The code or identifier of the entity defined by the Point of Sale Type Code (e.g. CRS code, Airline specific code, etc.). | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $POS_CodeText;
    /**
     * Constructor method for POS_FilterCriteriaType
     * @uses POS_FilterCriteriaType::setPOS_TypeCode()
     * @uses POS_FilterCriteriaType::setTravelAgencyInd()
     * @uses POS_FilterCriteriaType::setAggregator()
     * @uses POS_FilterCriteriaType::setPOS_CodeText()
     * @param string $pOS_TypeCode
     * @param bool $travelAgencyInd
     * @param \StructType\AggregatorType $aggregator
     * @param string $pOS_CodeText
     */
    public function __construct($pOS_TypeCode = null, $travelAgencyInd = null, \StructType\AggregatorType $aggregator = null, $pOS_CodeText = null)
    {
        $this
            ->setPOS_TypeCode($pOS_TypeCode)
            ->setTravelAgencyInd($travelAgencyInd)
            ->setAggregator($aggregator)
            ->setPOS_CodeText($pOS_CodeText);
    }
    /**
     * Get POS_TypeCode value
     * @return string
     */
    public function getPOS_TypeCode()
    {
        return $this->POS_TypeCode;
    }
    /**
     * Set POS_TypeCode value
     * @param string $pOS_TypeCode
     * @return \StructType\POS_FilterCriteriaType
     */
    public function setPOS_TypeCode($pOS_TypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_TypeCode) && !is_string($pOS_TypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_TypeCode, true), gettype($pOS_TypeCode)), __LINE__);
        }
        $this->POS_TypeCode = $pOS_TypeCode;
        return $this;
    }
    /**
     * Get TravelAgencyInd value
     * @return bool
     */
    public function getTravelAgencyInd()
    {
        return $this->TravelAgencyInd;
    }
    /**
     * Set TravelAgencyInd value
     * @param bool $travelAgencyInd
     * @return \StructType\POS_FilterCriteriaType
     */
    public function setTravelAgencyInd($travelAgencyInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($travelAgencyInd) && !is_bool($travelAgencyInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($travelAgencyInd, true), gettype($travelAgencyInd)), __LINE__);
        }
        $this->TravelAgencyInd = $travelAgencyInd;
        return $this;
    }
    /**
     * Get Aggregator value
     * @return \StructType\AggregatorType|null
     */
    public function getAggregator()
    {
        return $this->Aggregator;
    }
    /**
     * Set Aggregator value
     * @param \StructType\AggregatorType $aggregator
     * @return \StructType\POS_FilterCriteriaType
     */
    public function setAggregator(\StructType\AggregatorType $aggregator = null)
    {
        $this->Aggregator = $aggregator;
        return $this;
    }
    /**
     * Get POS_CodeText value
     * @return string|null
     */
    public function getPOS_CodeText()
    {
        return $this->POS_CodeText;
    }
    /**
     * Set POS_CodeText value
     * @param string $pOS_CodeText
     * @return \StructType\POS_FilterCriteriaType
     */
    public function setPOS_CodeText($pOS_CodeText = null)
    {
        // validation for constraint: string
        if (!is_null($pOS_CodeText) && !is_string($pOS_CodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOS_CodeText, true), gettype($pOS_CodeText)), __LINE__);
        }
        $this->POS_CodeText = $pOS_CodeText;
        return $this;
    }
}
