<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherOffersType StructType
 * Meta information extracted from the WSDL
 * - documentation: Grouping of Offers returned by a single ORA.
 * @subpackage Structs
 */
class OtherOffersType extends AbstractStructBase
{
    /**
     * The ALaCarteOffer
     * Meta information extracted from the WSDL
     * - documentation: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is defined as a
     * container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple flight-related
     * Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response] Shopping
     * Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ALaCarteOfferType[]
     */
    public $ALaCarteOffer;
    /**
     * The Offer
     * Meta information extracted from the WSDL
     * - documentation: New Offer: A proposal to sell a specific set of products or Services under specific conditions, for a certain price. Can be the response to a shopping request. Can be a regular Offer or an A La Carte Offer. A La Carte Offer is
     * defined as a container for A La Carte Offer Items. This supports a shopping basket concept for non-flight services. The main purpose of this structure is to reduce the size of the messages by inserting Offer Items which are applicable to multiple
     * flight-related Offers. NB. For the OfferID of the ALaCarteOffer: Default OfferID identifier for A La Carte Offer Items in a scenario where items here are not selected for a flight-related Offer above. Business Identifier Fields: - [Shopping Response]
     * Shopping Response ID - Offer ID - [Carrier] Airline Designator Code
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NewOfferType[]
     */
    public $Offer;
    /**
     * Constructor method for OtherOffersType
     * @uses OtherOffersType::setALaCarteOffer()
     * @uses OtherOffersType::setOffer()
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @param \StructType\NewOfferType[] $offer
     */
    public function __construct(array $aLaCarteOffer = array(), array $offer = array())
    {
        $this
            ->setALaCarteOffer($aLaCarteOffer)
            ->setOffer($offer);
    }
    /**
     * Get ALaCarteOffer value
     * @return \StructType\ALaCarteOfferType[]|null
     */
    public function getALaCarteOffer()
    {
        return $this->ALaCarteOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setALaCarteOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setALaCarteOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherOffersTypeALaCarteOfferItem) {
            // validation for constraint: itemType
            if (!$otherOffersTypeALaCarteOfferItem instanceof \StructType\ALaCarteOfferType) {
                $invalidValues[] = is_object($otherOffersTypeALaCarteOfferItem) ? get_class($otherOffersTypeALaCarteOfferItem) : sprintf('%s(%s)', gettype($otherOffersTypeALaCarteOfferItem), var_export($otherOffersTypeALaCarteOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType[] $aLaCarteOffer
     * @return \StructType\OtherOffersType
     */
    public function setALaCarteOffer(array $aLaCarteOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($aLaCarteOfferArrayErrorMessage = self::validateALaCarteOfferForArrayConstraintsFromSetALaCarteOffer($aLaCarteOffer))) {
            throw new \InvalidArgumentException($aLaCarteOfferArrayErrorMessage, __LINE__);
        }
        $this->ALaCarteOffer = $aLaCarteOffer;
        return $this;
    }
    /**
     * Add item to ALaCarteOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ALaCarteOfferType $item
     * @return \StructType\OtherOffersType
     */
    public function addToALaCarteOffer(\StructType\ALaCarteOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ALaCarteOfferType) {
            throw new \InvalidArgumentException(sprintf('The ALaCarteOffer property can only contain items of type \StructType\ALaCarteOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ALaCarteOffer[] = $item;
        return $this;
    }
    /**
     * Get Offer value
     * @return \StructType\NewOfferType[]|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * This method is responsible for validating the values passed to the setOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferForArrayConstraintsFromSetOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $otherOffersTypeOfferItem) {
            // validation for constraint: itemType
            if (!$otherOffersTypeOfferItem instanceof \StructType\NewOfferType) {
                $invalidValues[] = is_object($otherOffersTypeOfferItem) ? get_class($otherOffersTypeOfferItem) : sprintf('%s(%s)', gettype($otherOffersTypeOfferItem), var_export($otherOffersTypeOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Offer property can only contain items of type \StructType\NewOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\NewOfferType[] $offer
     * @return \StructType\OtherOffersType
     */
    public function setOffer(array $offer = array())
    {
        // validation for constraint: array
        if ('' !== ($offerArrayErrorMessage = self::validateOfferForArrayConstraintsFromSetOffer($offer))) {
            throw new \InvalidArgumentException($offerArrayErrorMessage, __LINE__);
        }
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Add item to Offer value
     * @throws \InvalidArgumentException
     * @param \StructType\NewOfferType $item
     * @return \StructType\OtherOffersType
     */
    public function addToOffer(\StructType\NewOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NewOfferType) {
            throw new \InvalidArgumentException(sprintf('The Offer property can only contain items of type \StructType\NewOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Offer[] = $item;
        return $this;
    }
}
