<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Other service information used for long sells.
 * @subpackage Structs
 */
class OtherItemType extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description text value. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * Constructor method for OtherItemType
     * @uses OtherItemType::setPrice()
     * @uses OtherItemType::setDescText()
     * @param \StructType\PriceType $price
     * @param string $descText
     */
    public function __construct(\StructType\PriceType $price = null, $descText = null)
    {
        $this
            ->setPrice($price)
            ->setDescText($descText);
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\OtherItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\OtherItemType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
}
