<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderingQtyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Minimum/Maximum Option Ordering Quantities.
 * @subpackage Structs
 */
class OrderingQtyType extends AbstractStructBase
{
    /**
     * The MaximumQty
     * Meta information extracted from the WSDL
     * - documentation: The MAXIMUM Quantity of the Option that may be ordered. Example: 4 | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MaximumQty;
    /**
     * The MinimumQty
     * Meta information extracted from the WSDL
     * - documentation: The MINIMUM Quantity of the Option that may be ordered. Example: 2 | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MinimumQty;
    /**
     * Constructor method for OrderingQtyType
     * @uses OrderingQtyType::setMaximumQty()
     * @uses OrderingQtyType::setMinimumQty()
     * @param float $maximumQty
     * @param float $minimumQty
     */
    public function __construct($maximumQty = null, $minimumQty = null)
    {
        $this
            ->setMaximumQty($maximumQty)
            ->setMinimumQty($minimumQty);
    }
    /**
     * Get MaximumQty value
     * @return float|null
     */
    public function getMaximumQty()
    {
        return $this->MaximumQty;
    }
    /**
     * Set MaximumQty value
     * @param float $maximumQty
     * @return \StructType\OrderingQtyType
     */
    public function setMaximumQty($maximumQty = null)
    {
        // validation for constraint: float
        if (!is_null($maximumQty) && !(is_float($maximumQty) || is_numeric($maximumQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximumQty, true), gettype($maximumQty)), __LINE__);
        }
        $this->MaximumQty = $maximumQty;
        return $this;
    }
    /**
     * Get MinimumQty value
     * @return float|null
     */
    public function getMinimumQty()
    {
        return $this->MinimumQty;
    }
    /**
     * Set MinimumQty value
     * @param float $minimumQty
     * @return \StructType\OrderingQtyType
     */
    public function setMinimumQty($minimumQty = null)
    {
        // validation for constraint: float
        if (!is_null($minimumQty) && !(is_float($minimumQty) || is_numeric($minimumQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimumQty, true), gettype($minimumQty)), __LINE__);
        }
        $this->MinimumQty = $minimumQty;
        return $this;
    }
}
