<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderedServiceAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Ordered Service Association
 * @subpackage Structs
 */
class OrderedServiceAssociationType extends AbstractStructBase
{
    /**
     * The PaxSegment
     * Meta information extracted from the WSDL
     * - documentation: Transportation of a passenger on a Dated Operating Segment. - [Dated Marketing Segment] (All identifying fields) - [Order] Order ID - [Individual] (no identifier available)
     * - choice: PaxSegment | SeatOnLeg | ServiceDefinition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentType
     */
    public $PaxSegment;
    /**
     * The SeatOnLeg
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg. Business Identifier Fields: - [Dated Operating Leg] (all identifier fields) - [Seat] (all identifier fields)
     * - choice: PaxSegment | SeatOnLeg | ServiceDefinition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatOnLegType
     */
    public $SeatOnLeg;
    /**
     * The ServiceDefinition
     * Meta information extracted from the WSDL
     * - documentation: Description and characteristics of a non-flight product or service that can be separately sold and delivered. E.g. bag, seat, meal on a flight. Business Identifier Fields: - [Shopping Response] Shopping Response ID - [Carrier]
     * Airline Designator Code - Service Definition ID
     * - choice: PaxSegment | SeatOnLeg | ServiceDefinition
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceDefinitionType
     */
    public $ServiceDefinition;
    /**
     * Constructor method for OrderedServiceAssociationType
     * @uses OrderedServiceAssociationType::setPaxSegment()
     * @uses OrderedServiceAssociationType::setSeatOnLeg()
     * @uses OrderedServiceAssociationType::setServiceDefinition()
     * @param \StructType\PaxSegmentType $paxSegment
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @param \StructType\ServiceDefinitionType $serviceDefinition
     */
    public function __construct(\StructType\PaxSegmentType $paxSegment = null, \StructType\SeatOnLegType $seatOnLeg = null, \StructType\ServiceDefinitionType $serviceDefinition = null)
    {
        $this
            ->setPaxSegment($paxSegment)
            ->setSeatOnLeg($seatOnLeg)
            ->setServiceDefinition($serviceDefinition);
    }
    /**
     * Get PaxSegment value
     * @return \StructType\PaxSegmentType
     */
    public function getPaxSegment()
    {
        return isset($this->PaxSegment) ? $this->PaxSegment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentForChoiceConstraintsFromSetPaxSegment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SeatOnLeg',
            'ServiceDefinition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegment can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentType $paxSegment
     * @return \StructType\OrderedServiceAssociationType
     */
    public function setPaxSegment(\StructType\PaxSegmentType $paxSegment = null)
    {
        // validation for constraint: choice(PaxSegment, SeatOnLeg, ServiceDefinition)
        if ('' !== ($paxSegmentChoiceErrorMessage = self::validatePaxSegmentForChoiceConstraintsFromSetPaxSegment($paxSegment))) {
            throw new \InvalidArgumentException($paxSegmentChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegment) || (is_array($paxSegment) && empty($paxSegment))) {
            unset($this->PaxSegment);
        } else {
            $this->PaxSegment = $paxSegment;
        }
        return $this;
    }
    /**
     * Get SeatOnLeg value
     * @return \StructType\SeatOnLegType
     */
    public function getSeatOnLeg()
    {
        return isset($this->SeatOnLeg) ? $this->SeatOnLeg : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatOnLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatOnLeg method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegment',
            'ServiceDefinition',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatOnLeg can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatOnLeg, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatOnLeg value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @return \StructType\OrderedServiceAssociationType
     */
    public function setSeatOnLeg(\StructType\SeatOnLegType $seatOnLeg = null)
    {
        // validation for constraint: choice(PaxSegment, SeatOnLeg, ServiceDefinition)
        if ('' !== ($seatOnLegChoiceErrorMessage = self::validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($seatOnLeg))) {
            throw new \InvalidArgumentException($seatOnLegChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatOnLeg) || (is_array($seatOnLeg) && empty($seatOnLeg))) {
            unset($this->SeatOnLeg);
        } else {
            $this->SeatOnLeg = $seatOnLeg;
        }
        return $this;
    }
    /**
     * Get ServiceDefinition value
     * @return \StructType\ServiceDefinitionType
     */
    public function getServiceDefinition()
    {
        return isset($this->ServiceDefinition) ? $this->ServiceDefinition : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceDefinition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinition method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceDefinitionForChoiceConstraintsFromSetServiceDefinition($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegment',
            'SeatOnLeg',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinition can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinition, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceDefinition value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceDefinitionType $serviceDefinition
     * @return \StructType\OrderedServiceAssociationType
     */
    public function setServiceDefinition(\StructType\ServiceDefinitionType $serviceDefinition = null)
    {
        // validation for constraint: choice(PaxSegment, SeatOnLeg, ServiceDefinition)
        if ('' !== ($serviceDefinitionChoiceErrorMessage = self::validateServiceDefinitionForChoiceConstraintsFromSetServiceDefinition($serviceDefinition))) {
            throw new \InvalidArgumentException($serviceDefinitionChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceDefinition) || (is_array($serviceDefinition) && empty($serviceDefinition))) {
            unset($this->ServiceDefinition);
        } else {
            $this->ServiceDefinition = $serviceDefinition;
        }
        return $this;
    }
}
