<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStructureKeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
 * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
 * hold different sets of order items at different prices.
 * @subpackage Structs
 */
class OrderStructureKeyType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OrderItem
     * Meta information extracted from the WSDL
     * - documentation: An Order key individually priced item within an Order key Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrderItemKeyType[]
     */
    public $OrderItem;
    /**
     * The OrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order used to track the evolution of an Order and the changes made to it. | Order version number BDT.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderVersionNumber;
    /**
     * Constructor method for OrderStructureKeyType
     * @uses OrderStructureKeyType::setOrderID()
     * @uses OrderStructureKeyType::setOwnerCode()
     * @uses OrderStructureKeyType::setOrderItem()
     * @uses OrderStructureKeyType::setOrderVersionNumber()
     * @param string $orderID
     * @param string $ownerCode
     * @param \StructType\OrderItemKeyType[] $orderItem
     * @param int $orderVersionNumber
     */
    public function __construct($orderID = null, $ownerCode = null, array $orderItem = array(), $orderVersionNumber = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOwnerCode($ownerCode)
            ->setOrderItem($orderItem)
            ->setOrderVersionNumber($orderVersionNumber);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\OrderStructureKeyType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\OrderStructureKeyType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OrderItem value
     * @return \StructType\OrderItemKeyType[]|null
     */
    public function getOrderItem()
    {
        return $this->OrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderItemForArrayConstraintsFromSetOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderStructureKeyTypeOrderItemItem) {
            // validation for constraint: itemType
            if (!$orderStructureKeyTypeOrderItemItem instanceof \StructType\OrderItemKeyType) {
                $invalidValues[] = is_object($orderStructureKeyTypeOrderItemItem) ? get_class($orderStructureKeyTypeOrderItemItem) : sprintf('%s(%s)', gettype($orderStructureKeyTypeOrderItemItem), var_export($orderStructureKeyTypeOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderItem property can only contain items of type \StructType\OrderItemKeyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemKeyType[] $orderItem
     * @return \StructType\OrderStructureKeyType
     */
    public function setOrderItem(array $orderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($orderItemArrayErrorMessage = self::validateOrderItemForArrayConstraintsFromSetOrderItem($orderItem))) {
            throw new \InvalidArgumentException($orderItemArrayErrorMessage, __LINE__);
        }
        $this->OrderItem = $orderItem;
        return $this;
    }
    /**
     * Add item to OrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderItemKeyType $item
     * @return \StructType\OrderStructureKeyType
     */
    public function addToOrderItem(\StructType\OrderItemKeyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderItemKeyType) {
            throw new \InvalidArgumentException(sprintf('The OrderItem property can only contain items of type \StructType\OrderItemKeyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderItem[] = $item;
        return $this;
    }
    /**
     * Get OrderVersionNumber value
     * @return int|null
     */
    public function getOrderVersionNumber()
    {
        return $this->OrderVersionNumber;
    }
    /**
     * Set OrderVersionNumber value
     * @param int $orderVersionNumber
     * @return \StructType\OrderStructureKeyType
     */
    public function setOrderVersionNumber($orderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderVersionNumber) && !(is_int($orderVersionNumber) || ctype_digit($orderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderVersionNumber, true), gettype($orderVersionNumber)), __LINE__);
        }
        $this->OrderVersionNumber = $orderVersionNumber;
        return $this;
    }
}
