<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderServiceAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Order Service Association
 * @subpackage Structs
 */
class OrderServiceAssociationType extends AbstractStructBase
{
    /**
     * The PaxSegmentRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID . This will be a reference to a single passenger segment that will be defined in a data list or pax segment list in the contained message.
     * - choice: PaxSegmentRef | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefType
     */
    public $PaxSegmentRef;
    /**
     * The SeatOnLeg
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg. Business Identifier Fields: - [Dated Operating Leg] (all identifier fields) - [Seat] (all identifier fields)
     * - choice: PaxSegmentRef | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatOnLegType
     */
    public $SeatOnLeg;
    /**
     * The ServiceDefinitionRef
     * Meta information extracted from the WSDL
     * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * - choice: PaxSegmentRef | SeatOnLeg | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderServiceDefinitionRefType
     */
    public $ServiceDefinitionRef;
    /**
     * Constructor method for OrderServiceAssociationType
     * @uses OrderServiceAssociationType::setPaxSegmentRef()
     * @uses OrderServiceAssociationType::setSeatOnLeg()
     * @uses OrderServiceAssociationType::setServiceDefinitionRef()
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @param \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef
     */
    public function __construct(\StructType\PaxSegmentRefType $paxSegmentRef = null, \StructType\SeatOnLegType $seatOnLeg = null, \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        $this
            ->setPaxSegmentRef($paxSegmentRef)
            ->setSeatOnLeg($seatOnLeg)
            ->setServiceDefinitionRef($serviceDefinitionRef);
    }
    /**
     * Get PaxSegmentRef value
     * @return \StructType\PaxSegmentRefType
     */
    public function getPaxSegmentRef()
    {
        return isset($this->PaxSegmentRef) ? $this->PaxSegmentRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SeatOnLeg',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefType $paxSegmentRef
     * @return \StructType\OrderServiceAssociationType
     */
    public function setPaxSegmentRef(\StructType\PaxSegmentRefType $paxSegmentRef = null)
    {
        // validation for constraint: choice(PaxSegmentRef, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($paxSegmentRefChoiceErrorMessage = self::validatePaxSegmentRefForChoiceConstraintsFromSetPaxSegmentRef($paxSegmentRef))) {
            throw new \InvalidArgumentException($paxSegmentRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentRef) || (is_array($paxSegmentRef) && empty($paxSegmentRef))) {
            unset($this->PaxSegmentRef);
        } else {
            $this->PaxSegmentRef = $paxSegmentRef;
        }
        return $this;
    }
    /**
     * Get SeatOnLeg value
     * @return \StructType\SeatOnLegType
     */
    public function getSeatOnLeg()
    {
        return isset($this->SeatOnLeg) ? $this->SeatOnLeg : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatOnLeg method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatOnLeg method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegmentRef',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatOnLeg can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatOnLeg, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatOnLeg value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatOnLegType $seatOnLeg
     * @return \StructType\OrderServiceAssociationType
     */
    public function setSeatOnLeg(\StructType\SeatOnLegType $seatOnLeg = null)
    {
        // validation for constraint: choice(PaxSegmentRef, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($seatOnLegChoiceErrorMessage = self::validateSeatOnLegForChoiceConstraintsFromSetSeatOnLeg($seatOnLeg))) {
            throw new \InvalidArgumentException($seatOnLegChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatOnLeg) || (is_array($seatOnLeg) && empty($seatOnLeg))) {
            unset($this->SeatOnLeg);
        } else {
            $this->SeatOnLeg = $seatOnLeg;
        }
        return $this;
    }
    /**
     * Get ServiceDefinitionRef value
     * @return \StructType\OrderServiceDefinitionRefType
     */
    public function getServiceDefinitionRef()
    {
        return isset($this->ServiceDefinitionRef) ? $this->ServiceDefinitionRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxSegmentRef',
            'SeatOnLeg',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinitionRef can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinitionRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceDefinitionRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderServiceDefinitionRefType $serviceDefinitionRef
     * @return \StructType\OrderServiceAssociationType
     */
    public function setServiceDefinitionRef(\StructType\OrderServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        // validation for constraint: choice(PaxSegmentRef, SeatOnLeg, ServiceDefinitionRef)
        if ('' !== ($serviceDefinitionRefChoiceErrorMessage = self::validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($serviceDefinitionRef))) {
            throw new \InvalidArgumentException($serviceDefinitionRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceDefinitionRef) || (is_array($serviceDefinitionRef) && empty($serviceDefinitionRef))) {
            unset($this->ServiceDefinitionRef);
        } else {
            $this->ServiceDefinitionRef = $serviceDefinitionRef;
        }
        return $this;
    }
}
