<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReshopResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Reshop message
 * @subpackage Structs
 */
class OrderReshopResponseType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderKeyType
     */
    public $Order;
    /**
     * The ReshopResults
     * Meta information extracted from the WSDL
     * - documentation: ReshopResults
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ReshopResultsType
     */
    public $ReshopResults;
    /**
     * The ChangeFees
     * Meta information extracted from the WSDL
     * - documentation: Information related to a punishment imposed for breaking a law, rule, or contract.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PenaltyType
     */
    public $ChangeFees;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsOfferType[]
     */
    public $PaymentFunctions;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for OrderReshopResponseType
     * @uses OrderReshopResponseType::setOrder()
     * @uses OrderReshopResponseType::setReshopResults()
     * @uses OrderReshopResponseType::setChangeFees()
     * @uses OrderReshopResponseType::setDataLists()
     * @uses OrderReshopResponseType::setMetadata()
     * @uses OrderReshopResponseType::setPaxGroup()
     * @uses OrderReshopResponseType::setPaymentFunctions()
     * @uses OrderReshopResponseType::setProcessing()
     * @uses OrderReshopResponseType::setWarning()
     * @param \StructType\OrderKeyType $order
     * @param \StructType\ReshopResultsType $reshopResults
     * @param \StructType\PenaltyType $changeFees
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PaxGroupType $paxGroup
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(\StructType\OrderKeyType $order = null, \StructType\ReshopResultsType $reshopResults = null, \StructType\PenaltyType $changeFees = null, \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, \StructType\PaxGroupType $paxGroup = null, array $paymentFunctions = array(), \StructType\ResponseParametersResponseType $processing = null, array $warning = array())
    {
        $this
            ->setOrder($order)
            ->setReshopResults($reshopResults)
            ->setChangeFees($changeFees)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setPaxGroup($paxGroup)
            ->setPaymentFunctions($paymentFunctions)
            ->setProcessing($processing)
            ->setWarning($warning);
    }
    /**
     * Get Order value
     * @return \StructType\OrderKeyType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderKeyType $order
     * @return \StructType\OrderReshopResponseType
     */
    public function setOrder(\StructType\OrderKeyType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ReshopResults value
     * @return \StructType\ReshopResultsType
     */
    public function getReshopResults()
    {
        return $this->ReshopResults;
    }
    /**
     * Set ReshopResults value
     * @param \StructType\ReshopResultsType $reshopResults
     * @return \StructType\OrderReshopResponseType
     */
    public function setReshopResults(\StructType\ReshopResultsType $reshopResults = null)
    {
        $this->ReshopResults = $reshopResults;
        return $this;
    }
    /**
     * Get ChangeFees value
     * @return \StructType\PenaltyType|null
     */
    public function getChangeFees()
    {
        return $this->ChangeFees;
    }
    /**
     * Set ChangeFees value
     * @param \StructType\PenaltyType $changeFees
     * @return \StructType\OrderReshopResponseType
     */
    public function setChangeFees(\StructType\PenaltyType $changeFees = null)
    {
        $this->ChangeFees = $changeFees;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderReshopResponseType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderReshopResponseType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\OrderReshopResponseType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsOfferType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopResponseTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderReshopResponseTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsOfferType) {
                $invalidValues[] = is_object($orderReshopResponseTypePaymentFunctionsItem) ? get_class($orderReshopResponseTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderReshopResponseTypePaymentFunctionsItem), var_export($orderReshopResponseTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType[] $paymentFunctions
     * @return \StructType\OrderReshopResponseType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsOfferType $item
     * @return \StructType\OrderReshopResponseType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsOfferType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\OrderReshopResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderReshopResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$orderReshopResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($orderReshopResponseTypeWarningItem) ? get_class($orderReshopResponseTypeWarningItem) : sprintf('%s(%s)', gettype($orderReshopResponseTypeWarningItem), var_export($orderReshopResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\OrderReshopResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\OrderReshopResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
