<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderQuotePayloadType StructType
 * Meta information extracted from the WSDL
 * - documentation: Physical container for message data elements
 * @subpackage Structs
 */
class OrderQuotePayloadType extends AbstractStructBase
{
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The ExistingOrder
     * Meta information extracted from the WSDL
     * - documentation: Existing Order is a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and
     * services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each
     * passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExistingOrderType
     */
    public $ExistingOrder;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The OrderCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderCriteriaType
     */
    public $OrderCriteria;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxType[]
     */
    public $PaxList;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Criteria Specialization of Payment Functions: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentAssociatedFunctionsCriteriaType[]
     */
    public $PaymentFunctions;
    /**
     * The RepricedOrder
     * Meta information extracted from the WSDL
     * - documentation: Function to reprice entire Order (if only OrderID is supplied within Request) or Specific OrderItems (if defined in nested OrderItem elements)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RepricedOrderType
     */
    public $RepricedOrder;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType[]
     */
    public $ResponseParameters;
    /**
     * The SelectedOffers
     * Meta information extracted from the WSDL
     * - documentation: Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs). Each Offer
     * selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and 'a-la-carte' Offers
     * would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedOfferType[]
     */
    public $SelectedOffers;
    /**
     * Constructor method for OrderQuotePayloadType
     * @uses OrderQuotePayloadType::setContactInfoList()
     * @uses OrderQuotePayloadType::setExistingOrder()
     * @uses OrderQuotePayloadType::setFareWaiver()
     * @uses OrderQuotePayloadType::setOrderCriteria()
     * @uses OrderQuotePayloadType::setPaxList()
     * @uses OrderQuotePayloadType::setPaymentFunctions()
     * @uses OrderQuotePayloadType::setRepricedOrder()
     * @uses OrderQuotePayloadType::setResponseParameters()
     * @uses OrderQuotePayloadType::setSelectedOffers()
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\ExistingOrderType $existingOrder
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param \StructType\OrderCriteriaType $orderCriteria
     * @param \StructType\PaxType[] $paxList
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType[] $paymentFunctions
     * @param \StructType\RepricedOrderType $repricedOrder
     * @param \StructType\ResponseParametersRequestType[] $responseParameters
     * @param \StructType\SelectedOfferType[] $selectedOffers
     */
    public function __construct(array $contactInfoList = array(), \StructType\ExistingOrderType $existingOrder = null, array $fareWaiver = array(), \StructType\OrderCriteriaType $orderCriteria = null, array $paxList = array(), array $paymentFunctions = array(), \StructType\RepricedOrderType $repricedOrder = null, array $responseParameters = array(), array $selectedOffers = array())
    {
        $this
            ->setContactInfoList($contactInfoList)
            ->setExistingOrder($existingOrder)
            ->setFareWaiver($fareWaiver)
            ->setOrderCriteria($orderCriteria)
            ->setPaxList($paxList)
            ->setPaymentFunctions($paymentFunctions)
            ->setRepricedOrder($repricedOrder)
            ->setResponseParameters($responseParameters)
            ->setSelectedOffers($selectedOffers);
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($orderQuotePayloadTypeContactInfoListItem) ? get_class($orderQuotePayloadTypeContactInfoListItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypeContactInfoListItem), var_export($orderQuotePayloadTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\OrderQuotePayloadType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get ExistingOrder value
     * @return \StructType\ExistingOrderType|null
     */
    public function getExistingOrder()
    {
        return $this->ExistingOrder;
    }
    /**
     * Set ExistingOrder value
     * @param \StructType\ExistingOrderType $existingOrder
     * @return \StructType\OrderQuotePayloadType
     */
    public function setExistingOrder(\StructType\ExistingOrderType $existingOrder = null)
    {
        $this->ExistingOrder = $existingOrder;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($orderQuotePayloadTypeFareWaiverItem) ? get_class($orderQuotePayloadTypeFareWaiverItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypeFareWaiverItem), var_export($orderQuotePayloadTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\OrderQuotePayloadType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get OrderCriteria value
     * @return \StructType\OrderCriteriaType|null
     */
    public function getOrderCriteria()
    {
        return $this->OrderCriteria;
    }
    /**
     * Set OrderCriteria value
     * @param \StructType\OrderCriteriaType $orderCriteria
     * @return \StructType\OrderQuotePayloadType
     */
    public function setOrderCriteria(\StructType\OrderCriteriaType $orderCriteria = null)
    {
        $this->OrderCriteria = $orderCriteria;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxType[]|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxListForArrayConstraintsFromSetPaxList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypePaxListItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypePaxListItem instanceof \StructType\PaxType) {
                $invalidValues[] = is_object($orderQuotePayloadTypePaxListItem) ? get_class($orderQuotePayloadTypePaxListItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypePaxListItem), var_export($orderQuotePayloadTypePaxListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxList property can only contain items of type \StructType\PaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxList value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType[] $paxList
     * @return \StructType\OrderQuotePayloadType
     */
    public function setPaxList(array $paxList = array())
    {
        // validation for constraint: array
        if ('' !== ($paxListArrayErrorMessage = self::validatePaxListForArrayConstraintsFromSetPaxList($paxList))) {
            throw new \InvalidArgumentException($paxListArrayErrorMessage, __LINE__);
        }
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Add item to PaxList value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToPaxList(\StructType\PaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxType) {
            throw new \InvalidArgumentException(sprintf('The PaxList property can only contain items of type \StructType\PaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxList[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentAssociatedFunctionsCriteriaType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypePaymentFunctionsItem instanceof \StructType\PaymentAssociatedFunctionsCriteriaType) {
                $invalidValues[] = is_object($orderQuotePayloadTypePaymentFunctionsItem) ? get_class($orderQuotePayloadTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypePaymentFunctionsItem), var_export($orderQuotePayloadTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedFunctionsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType[] $paymentFunctions
     * @return \StructType\OrderQuotePayloadType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedFunctionsCriteriaType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToPaymentFunctions(\StructType\PaymentAssociatedFunctionsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentAssociatedFunctionsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedFunctionsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get RepricedOrder value
     * @return \StructType\RepricedOrderType|null
     */
    public function getRepricedOrder()
    {
        return $this->RepricedOrder;
    }
    /**
     * Set RepricedOrder value
     * @param \StructType\RepricedOrderType $repricedOrder
     * @return \StructType\OrderQuotePayloadType
     */
    public function setRepricedOrder(\StructType\RepricedOrderType $repricedOrder = null)
    {
        $this->RepricedOrder = $repricedOrder;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType[]|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * This method is responsible for validating the values passed to the setResponseParameters method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponseParameters method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponseParametersForArrayConstraintsFromSetResponseParameters(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypeResponseParametersItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypeResponseParametersItem instanceof \StructType\ResponseParametersRequestType) {
                $invalidValues[] = is_object($orderQuotePayloadTypeResponseParametersItem) ? get_class($orderQuotePayloadTypeResponseParametersItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypeResponseParametersItem), var_export($orderQuotePayloadTypeResponseParametersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResponseParameters property can only contain items of type \StructType\ResponseParametersRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResponseParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseParametersRequestType[] $responseParameters
     * @return \StructType\OrderQuotePayloadType
     */
    public function setResponseParameters(array $responseParameters = array())
    {
        // validation for constraint: array
        if ('' !== ($responseParametersArrayErrorMessage = self::validateResponseParametersForArrayConstraintsFromSetResponseParameters($responseParameters))) {
            throw new \InvalidArgumentException($responseParametersArrayErrorMessage, __LINE__);
        }
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
    /**
     * Add item to ResponseParameters value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseParametersRequestType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToResponseParameters(\StructType\ResponseParametersRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResponseParametersRequestType) {
            throw new \InvalidArgumentException(sprintf('The ResponseParameters property can only contain items of type \StructType\ResponseParametersRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResponseParameters[] = $item;
        return $this;
    }
    /**
     * Get SelectedOffers value
     * @return \StructType\SelectedOfferType[]|null
     */
    public function getSelectedOffers()
    {
        return $this->SelectedOffers;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOffers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOffersForArrayConstraintsFromSetSelectedOffers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderQuotePayloadTypeSelectedOffersItem) {
            // validation for constraint: itemType
            if (!$orderQuotePayloadTypeSelectedOffersItem instanceof \StructType\SelectedOfferType) {
                $invalidValues[] = is_object($orderQuotePayloadTypeSelectedOffersItem) ? get_class($orderQuotePayloadTypeSelectedOffersItem) : sprintf('%s(%s)', gettype($orderQuotePayloadTypeSelectedOffersItem), var_export($orderQuotePayloadTypeSelectedOffersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOffers property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType[] $selectedOffers
     * @return \StructType\OrderQuotePayloadType
     */
    public function setSelectedOffers(array $selectedOffers = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOffersArrayErrorMessage = self::validateSelectedOffersForArrayConstraintsFromSetSelectedOffers($selectedOffers))) {
            throw new \InvalidArgumentException($selectedOffersArrayErrorMessage, __LINE__);
        }
        $this->SelectedOffers = $selectedOffers;
        return $this;
    }
    /**
     * Add item to SelectedOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType $item
     * @return \StructType\OrderQuotePayloadType
     */
    public function addToSelectedOffers(\StructType\SelectedOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOfferType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOffers property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOffers[] = $item;
        return $this;
    }
}
