<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderListResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Response for Order list
 * @subpackage Structs
 */
class OrderListResponseType extends AbstractStructBase
{
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The MatchedOrder
     * Meta information extracted from the WSDL
     * - documentation: List of Order IDs and order information which match the Filter Criteria specified in OrderListRQ.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MatchedOrderType[]
     */
    public $MatchedOrder;
    /**
     * The Processing
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersResponseType
     */
    public $Processing;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WarningType[]
     */
    public $Warning;
    /**
     * Constructor method for OrderListResponseType
     * @uses OrderListResponseType::setContactInfoList()
     * @uses OrderListResponseType::setMatchedOrder()
     * @uses OrderListResponseType::setProcessing()
     * @uses OrderListResponseType::setWarning()
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\MatchedOrderType[] $matchedOrder
     * @param \StructType\ResponseParametersResponseType $processing
     * @param \StructType\WarningType[] $warning
     */
    public function __construct(array $contactInfoList = array(), array $matchedOrder = array(), \StructType\ResponseParametersResponseType $processing = null, array $warning = array())
    {
        $this
            ->setContactInfoList($contactInfoList)
            ->setMatchedOrder($matchedOrder)
            ->setProcessing($processing)
            ->setWarning($warning);
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderListResponseTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$orderListResponseTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($orderListResponseTypeContactInfoListItem) ? get_class($orderListResponseTypeContactInfoListItem) : sprintf('%s(%s)', gettype($orderListResponseTypeContactInfoListItem), var_export($orderListResponseTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\OrderListResponseType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\OrderListResponseType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get MatchedOrder value
     * @return \StructType\MatchedOrderType[]|null
     */
    public function getMatchedOrder()
    {
        return $this->MatchedOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setMatchedOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMatchedOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMatchedOrderForArrayConstraintsFromSetMatchedOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderListResponseTypeMatchedOrderItem) {
            // validation for constraint: itemType
            if (!$orderListResponseTypeMatchedOrderItem instanceof \StructType\MatchedOrderType) {
                $invalidValues[] = is_object($orderListResponseTypeMatchedOrderItem) ? get_class($orderListResponseTypeMatchedOrderItem) : sprintf('%s(%s)', gettype($orderListResponseTypeMatchedOrderItem), var_export($orderListResponseTypeMatchedOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MatchedOrder property can only contain items of type \StructType\MatchedOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MatchedOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedOrderType[] $matchedOrder
     * @return \StructType\OrderListResponseType
     */
    public function setMatchedOrder(array $matchedOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($matchedOrderArrayErrorMessage = self::validateMatchedOrderForArrayConstraintsFromSetMatchedOrder($matchedOrder))) {
            throw new \InvalidArgumentException($matchedOrderArrayErrorMessage, __LINE__);
        }
        $this->MatchedOrder = $matchedOrder;
        return $this;
    }
    /**
     * Add item to MatchedOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\MatchedOrderType $item
     * @return \StructType\OrderListResponseType
     */
    public function addToMatchedOrder(\StructType\MatchedOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MatchedOrderType) {
            throw new \InvalidArgumentException(sprintf('The MatchedOrder property can only contain items of type \StructType\MatchedOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MatchedOrder[] = $item;
        return $this;
    }
    /**
     * Get Processing value
     * @return \StructType\ResponseParametersResponseType|null
     */
    public function getProcessing()
    {
        return $this->Processing;
    }
    /**
     * Set Processing value
     * @param \StructType\ResponseParametersResponseType $processing
     * @return \StructType\OrderListResponseType
     */
    public function setProcessing(\StructType\ResponseParametersResponseType $processing = null)
    {
        $this->Processing = $processing;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * This method is responsible for validating the values passed to the setWarning method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarning method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningForArrayConstraintsFromSetWarning(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderListResponseTypeWarningItem) {
            // validation for constraint: itemType
            if (!$orderListResponseTypeWarningItem instanceof \StructType\WarningType) {
                $invalidValues[] = is_object($orderListResponseTypeWarningItem) ? get_class($orderListResponseTypeWarningItem) : sprintf('%s(%s)', gettype($orderListResponseTypeWarningItem), var_export($orderListResponseTypeWarningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType[] $warning
     * @return \StructType\OrderListResponseType
     */
    public function setWarning(array $warning = array())
    {
        // validation for constraint: array
        if ('' !== ($warningArrayErrorMessage = self::validateWarningForArrayConstraintsFromSetWarning($warning))) {
            throw new \InvalidArgumentException($warningArrayErrorMessage, __LINE__);
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\WarningType $item
     * @return \StructType\OrderListResponseType
     */
    public function addToWarning(\StructType\WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of type \StructType\WarningType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
}
