<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderKeyType StructType
 * Meta information extracted from the WSDL
 * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
 * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
 * hold different sets of order items at different prices.
 * @subpackage Structs
 */
class OrderKeyType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date time by which the order is created. Examples: 2018-09-05T15:52:01Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The OrderVersionNumber
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order used to track the evolution of an Order and the changes made to it. | Order version number BDT.
     * - base: xs:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrderVersionNumber;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Status instance. See ATSB Codeset OrderStatus for possible values. | The possible statuses of an Order {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Status, coded{/codeListName}
     * {codeListIdentifier}ORDERSTATUS{/codeListIdentifier} | represents the statuses of an Order
     * - base: OrderStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for OrderKeyType
     * @uses OrderKeyType::setOrderID()
     * @uses OrderKeyType::setOwnerCode()
     * @uses OrderKeyType::setCreationDateTime()
     * @uses OrderKeyType::setOrderVersionNumber()
     * @uses OrderKeyType::setStatusCode()
     * @param string $orderID
     * @param string $ownerCode
     * @param string $creationDateTime
     * @param int $orderVersionNumber
     * @param string $statusCode
     */
    public function __construct($orderID = null, $ownerCode = null, $creationDateTime = null, $orderVersionNumber = null, $statusCode = null)
    {
        $this
            ->setOrderID($orderID)
            ->setOwnerCode($ownerCode)
            ->setCreationDateTime($creationDateTime)
            ->setOrderVersionNumber($orderVersionNumber)
            ->setStatusCode($statusCode);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\OrderKeyType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\OrderKeyType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\OrderKeyType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get OrderVersionNumber value
     * @return int|null
     */
    public function getOrderVersionNumber()
    {
        return $this->OrderVersionNumber;
    }
    /**
     * Set OrderVersionNumber value
     * @param int $orderVersionNumber
     * @return \StructType\OrderKeyType
     */
    public function setOrderVersionNumber($orderVersionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderVersionNumber) && !(is_int($orderVersionNumber) || ctype_digit($orderVersionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderVersionNumber, true), gettype($orderVersionNumber)), __LINE__);
        }
        $this->OrderVersionNumber = $orderVersionNumber;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\OrderKeyType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
}
