<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderHistoryResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to the response for Order History
 * @subpackage Structs
 */
class OrderHistoryResponseType extends AbstractStructBase
{
    /**
     * The OrderID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned ID which uniquely identifies a specific Order across several messages. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an
     * agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderID;
    /**
     * The ChangeGroup
     * Meta information extracted from the WSDL
     * - documentation: A node containing change operation group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ChangeGroupType[]
     */
    public $ChangeGroup;
    /**
     * Constructor method for OrderHistoryResponseType
     * @uses OrderHistoryResponseType::setOrderID()
     * @uses OrderHistoryResponseType::setChangeGroup()
     * @param string $orderID
     * @param \StructType\ChangeGroupType[] $changeGroup
     */
    public function __construct($orderID = null, array $changeGroup = array())
    {
        $this
            ->setOrderID($orderID)
            ->setChangeGroup($changeGroup);
    }
    /**
     * Get OrderID value
     * @return string
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\OrderHistoryResponseType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get ChangeGroup value
     * @return \StructType\ChangeGroupType[]|null
     */
    public function getChangeGroup()
    {
        return $this->ChangeGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeGroupForArrayConstraintsFromSetChangeGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderHistoryResponseTypeChangeGroupItem) {
            // validation for constraint: itemType
            if (!$orderHistoryResponseTypeChangeGroupItem instanceof \StructType\ChangeGroupType) {
                $invalidValues[] = is_object($orderHistoryResponseTypeChangeGroupItem) ? get_class($orderHistoryResponseTypeChangeGroupItem) : sprintf('%s(%s)', gettype($orderHistoryResponseTypeChangeGroupItem), var_export($orderHistoryResponseTypeChangeGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeGroup property can only contain items of type \StructType\ChangeGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeGroupType[] $changeGroup
     * @return \StructType\OrderHistoryResponseType
     */
    public function setChangeGroup(array $changeGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($changeGroupArrayErrorMessage = self::validateChangeGroupForArrayConstraintsFromSetChangeGroup($changeGroup))) {
            throw new \InvalidArgumentException($changeGroupArrayErrorMessage, __LINE__);
        }
        $this->ChangeGroup = $changeGroup;
        return $this;
    }
    /**
     * Add item to ChangeGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeGroupType $item
     * @return \StructType\OrderHistoryResponseType
     */
    public function addToChangeGroup(\StructType\ChangeGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeGroupType) {
            throw new \InvalidArgumentException(sprintf('The ChangeGroup property can only contain items of type \StructType\ChangeGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeGroup[] = $item;
        return $this;
    }
}
