<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderHistoryRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for Order History
 * @subpackage Structs
 */
class OrderHistoryRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderKeyType
     */
    public $Order;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OrderHistoryRequestType
     * @uses OrderHistoryRequestType::setOrder()
     * @uses OrderHistoryRequestType::setResponseParameters()
     * @param \StructType\OrderKeyType $order
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\OrderKeyType $order = null, \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setOrder($order)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get Order value
     * @return \StructType\OrderKeyType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderKeyType $order
     * @return \StructType\OrderHistoryRequestType
     */
    public function setOrder(\StructType\OrderKeyType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderHistoryRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
