<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderForfeitedInfoListType StructType
 * Meta information extracted from the WSDL
 * - documentation: list of Order Forfeited Information.
 * @subpackage Structs
 */
class OrderForfeitedInfoListType extends AbstractStructBase
{
    /**
     * The ForfeitedInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to an amount which could not be recovered as a consequence of a servicing operation.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderForfeitedInfoType[]
     */
    public $ForfeitedInfo;
    /**
     * Constructor method for OrderForfeitedInfoListType
     * @uses OrderForfeitedInfoListType::setForfeitedInfo()
     * @param \StructType\OrderForfeitedInfoType[] $forfeitedInfo
     */
    public function __construct(array $forfeitedInfo = array())
    {
        $this
            ->setForfeitedInfo($forfeitedInfo);
    }
    /**
     * Get ForfeitedInfo value
     * @return \StructType\OrderForfeitedInfoType[]
     */
    public function getForfeitedInfo()
    {
        return $this->ForfeitedInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setForfeitedInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setForfeitedInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateForfeitedInfoForArrayConstraintsFromSetForfeitedInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderForfeitedInfoListTypeForfeitedInfoItem) {
            // validation for constraint: itemType
            if (!$orderForfeitedInfoListTypeForfeitedInfoItem instanceof \StructType\OrderForfeitedInfoType) {
                $invalidValues[] = is_object($orderForfeitedInfoListTypeForfeitedInfoItem) ? get_class($orderForfeitedInfoListTypeForfeitedInfoItem) : sprintf('%s(%s)', gettype($orderForfeitedInfoListTypeForfeitedInfoItem), var_export($orderForfeitedInfoListTypeForfeitedInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ForfeitedInfo property can only contain items of type \StructType\OrderForfeitedInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ForfeitedInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderForfeitedInfoType[] $forfeitedInfo
     * @return \StructType\OrderForfeitedInfoListType
     */
    public function setForfeitedInfo(array $forfeitedInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($forfeitedInfoArrayErrorMessage = self::validateForfeitedInfoForArrayConstraintsFromSetForfeitedInfo($forfeitedInfo))) {
            throw new \InvalidArgumentException($forfeitedInfoArrayErrorMessage, __LINE__);
        }
        $this->ForfeitedInfo = $forfeitedInfo;
        return $this;
    }
    /**
     * Add item to ForfeitedInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderForfeitedInfoType $item
     * @return \StructType\OrderForfeitedInfoListType
     */
    public function addToForfeitedInfo(\StructType\OrderForfeitedInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderForfeitedInfoType) {
            throw new \InvalidArgumentException(sprintf('The ForfeitedInfo property can only contain items of type \StructType\OrderForfeitedInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ForfeitedInfo[] = $item;
        return $this;
    }
}
