<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderCreateRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Order Create message
 * @subpackage Structs
 */
class OrderCreateRequestType extends AbstractStructBase
{
    /**
     * The CreateOrder
     * Meta information extracted from the WSDL
     * - documentation: Create Order
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CreateOrderType
     */
    public $CreateOrder;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The Commission
     * Meta information extracted from the WSDL
     * - documentation: An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommissionType[]
     */
    public $Commission;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxGroupType[]
     */
    public $PaxGroup;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsCreateType[]
     */
    public $PaymentFunctions;
    /**
     * The Promotion
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionType[]
     */
    public $Promotion;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OrderCreateRequestType
     * @uses OrderCreateRequestType::setCreateOrder()
     * @uses OrderCreateRequestType::setBookingRef()
     * @uses OrderCreateRequestType::setCommission()
     * @uses OrderCreateRequestType::setDataLists()
     * @uses OrderCreateRequestType::setMetadata()
     * @uses OrderCreateRequestType::setPaxGroup()
     * @uses OrderCreateRequestType::setPaymentFunctions()
     * @uses OrderCreateRequestType::setPromotion()
     * @uses OrderCreateRequestType::setResponseParameters()
     * @param \StructType\CreateOrderType $createOrder
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\CommissionType[] $commission
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\PaxGroupType[] $paxGroup
     * @param \StructType\PaymentFunctionsCreateType[] $paymentFunctions
     * @param \StructType\PromotionType[] $promotion
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\CreateOrderType $createOrder = null, array $bookingRef = array(), array $commission = array(), \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, array $paxGroup = array(), array $paymentFunctions = array(), array $promotion = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setCreateOrder($createOrder)
            ->setBookingRef($bookingRef)
            ->setCommission($commission)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setPaxGroup($paxGroup)
            ->setPaymentFunctions($paymentFunctions)
            ->setPromotion($promotion)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get CreateOrder value
     * @return \StructType\CreateOrderType
     */
    public function getCreateOrder()
    {
        return $this->CreateOrder;
    }
    /**
     * Set CreateOrder value
     * @param \StructType\CreateOrderType $createOrder
     * @return \StructType\OrderCreateRequestType
     */
    public function setCreateOrder(\StructType\CreateOrderType $createOrder = null)
    {
        $this->CreateOrder = $createOrder;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderCreateRequestTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$orderCreateRequestTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($orderCreateRequestTypeBookingRefItem) ? get_class($orderCreateRequestTypeBookingRefItem) : sprintf('%s(%s)', gettype($orderCreateRequestTypeBookingRefItem), var_export($orderCreateRequestTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\OrderCreateRequestType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\OrderCreateRequestType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get Commission value
     * @return \StructType\CommissionType[]|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * This method is responsible for validating the values passed to the setCommission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionForArrayConstraintsFromSetCommission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderCreateRequestTypeCommissionItem) {
            // validation for constraint: itemType
            if (!$orderCreateRequestTypeCommissionItem instanceof \StructType\CommissionType) {
                $invalidValues[] = is_object($orderCreateRequestTypeCommissionItem) ? get_class($orderCreateRequestTypeCommissionItem) : sprintf('%s(%s)', gettype($orderCreateRequestTypeCommissionItem), var_export($orderCreateRequestTypeCommissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType[] $commission
     * @return \StructType\OrderCreateRequestType
     */
    public function setCommission(array $commission = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionArrayErrorMessage = self::validateCommissionForArrayConstraintsFromSetCommission($commission))) {
            throw new \InvalidArgumentException($commissionArrayErrorMessage, __LINE__);
        }
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Add item to Commission value
     * @throws \InvalidArgumentException
     * @param \StructType\CommissionType $item
     * @return \StructType\OrderCreateRequestType
     */
    public function addToCommission(\StructType\CommissionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommissionType) {
            throw new \InvalidArgumentException(sprintf('The Commission property can only contain items of type \StructType\CommissionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commission[] = $item;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderCreateRequestType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderCreateRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType[]|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxGroupForArrayConstraintsFromSetPaxGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderCreateRequestTypePaxGroupItem) {
            // validation for constraint: itemType
            if (!$orderCreateRequestTypePaxGroupItem instanceof \StructType\PaxGroupType) {
                $invalidValues[] = is_object($orderCreateRequestTypePaxGroupItem) ? get_class($orderCreateRequestTypePaxGroupItem) : sprintf('%s(%s)', gettype($orderCreateRequestTypePaxGroupItem), var_export($orderCreateRequestTypePaxGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxGroup property can only contain items of type \StructType\PaxGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxGroupType[] $paxGroup
     * @return \StructType\OrderCreateRequestType
     */
    public function setPaxGroup(array $paxGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($paxGroupArrayErrorMessage = self::validatePaxGroupForArrayConstraintsFromSetPaxGroup($paxGroup))) {
            throw new \InvalidArgumentException($paxGroupArrayErrorMessage, __LINE__);
        }
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Add item to PaxGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxGroupType $item
     * @return \StructType\OrderCreateRequestType
     */
    public function addToPaxGroup(\StructType\PaxGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxGroupType) {
            throw new \InvalidArgumentException(sprintf('The PaxGroup property can only contain items of type \StructType\PaxGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxGroup[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsCreateType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderCreateRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderCreateRequestTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsCreateType) {
                $invalidValues[] = is_object($orderCreateRequestTypePaymentFunctionsItem) ? get_class($orderCreateRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderCreateRequestTypePaymentFunctionsItem), var_export($orderCreateRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCreateType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCreateType[] $paymentFunctions
     * @return \StructType\OrderCreateRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsCreateType $item
     * @return \StructType\OrderCreateRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsCreateType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsCreateType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsCreateType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Promotion value
     * @return \StructType\PromotionType[]|null
     */
    public function getPromotion()
    {
        return $this->Promotion;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionForArrayConstraintsFromSetPromotion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderCreateRequestTypePromotionItem) {
            // validation for constraint: itemType
            if (!$orderCreateRequestTypePromotionItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($orderCreateRequestTypePromotionItem) ? get_class($orderCreateRequestTypePromotionItem) : sprintf('%s(%s)', gettype($orderCreateRequestTypePromotionItem), var_export($orderCreateRequestTypePromotionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotion
     * @return \StructType\OrderCreateRequestType
     */
    public function setPromotion(array $promotion = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionArrayErrorMessage = self::validatePromotionForArrayConstraintsFromSetPromotion($promotion))) {
            throw new \InvalidArgumentException($promotionArrayErrorMessage, __LINE__);
        }
        $this->Promotion = $promotion;
        return $this;
    }
    /**
     * Add item to Promotion value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\OrderCreateRequestType
     */
    public function addToPromotion(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The Promotion property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Promotion[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OrderCreateRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
