<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChangeRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request for Order Change
 * @subpackage Structs
 */
class OrderChangeRequestType extends AbstractStructBase
{
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderFilterCriteriaType
     */
    public $Order;
    /**
     * The BookingRef
     * Meta information extracted from the WSDL
     * - documentation: Information related to a booking or reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BookingRefType[]
     */
    public $BookingRef;
    /**
     * The ChangeOrderChoice
     * Meta information extracted from the WSDL
     * - documentation: Change Order Choice
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChangeOrderChoiceType
     */
    public $ChangeOrderChoice;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DataListsType
     */
    public $DataLists;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The OrderChangeParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersOrderChangeType
     */
    public $OrderChangeParameters;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaxGroupType[]
     */
    public $PaxGroup;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentFunctionsChangeType[]
     */
    public $PaymentFunctions;
    /**
     * Constructor method for OrderChangeRequestType
     * @uses OrderChangeRequestType::setOrder()
     * @uses OrderChangeRequestType::setBookingRef()
     * @uses OrderChangeRequestType::setChangeOrderChoice()
     * @uses OrderChangeRequestType::setDataLists()
     * @uses OrderChangeRequestType::setMetadata()
     * @uses OrderChangeRequestType::setOrderChangeParameters()
     * @uses OrderChangeRequestType::setPaxGroup()
     * @uses OrderChangeRequestType::setPaymentFunctions()
     * @param \StructType\OrderFilterCriteriaType $order
     * @param \StructType\BookingRefType[] $bookingRef
     * @param \StructType\ChangeOrderChoiceType $changeOrderChoice
     * @param \StructType\DataListsType $dataLists
     * @param \StructType\MetadataType $metadata
     * @param \StructType\ResponseParametersOrderChangeType $orderChangeParameters
     * @param \StructType\PaxGroupType[] $paxGroup
     * @param \StructType\PaymentFunctionsChangeType[] $paymentFunctions
     */
    public function __construct(\StructType\OrderFilterCriteriaType $order = null, array $bookingRef = array(), \StructType\ChangeOrderChoiceType $changeOrderChoice = null, \StructType\DataListsType $dataLists = null, \StructType\MetadataType $metadata = null, \StructType\ResponseParametersOrderChangeType $orderChangeParameters = null, array $paxGroup = array(), array $paymentFunctions = array())
    {
        $this
            ->setOrder($order)
            ->setBookingRef($bookingRef)
            ->setChangeOrderChoice($changeOrderChoice)
            ->setDataLists($dataLists)
            ->setMetadata($metadata)
            ->setOrderChangeParameters($orderChangeParameters)
            ->setPaxGroup($paxGroup)
            ->setPaymentFunctions($paymentFunctions);
    }
    /**
     * Get Order value
     * @return \StructType\OrderFilterCriteriaType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderFilterCriteriaType $order
     * @return \StructType\OrderChangeRequestType
     */
    public function setOrder(\StructType\OrderFilterCriteriaType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return \StructType\BookingRefType[]|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingRefForArrayConstraintsFromSetBookingRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderChangeRequestTypeBookingRefItem) {
            // validation for constraint: itemType
            if (!$orderChangeRequestTypeBookingRefItem instanceof \StructType\BookingRefType) {
                $invalidValues[] = is_object($orderChangeRequestTypeBookingRefItem) ? get_class($orderChangeRequestTypeBookingRefItem) : sprintf('%s(%s)', gettype($orderChangeRequestTypeBookingRefItem), var_export($orderChangeRequestTypeBookingRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType[] $bookingRef
     * @return \StructType\OrderChangeRequestType
     */
    public function setBookingRef(array $bookingRef = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingRefArrayErrorMessage = self::validateBookingRefForArrayConstraintsFromSetBookingRef($bookingRef))) {
            throw new \InvalidArgumentException($bookingRefArrayErrorMessage, __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Add item to BookingRef value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingRefType $item
     * @return \StructType\OrderChangeRequestType
     */
    public function addToBookingRef(\StructType\BookingRefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingRefType) {
            throw new \InvalidArgumentException(sprintf('The BookingRef property can only contain items of type \StructType\BookingRefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BookingRef[] = $item;
        return $this;
    }
    /**
     * Get ChangeOrderChoice value
     * @return \StructType\ChangeOrderChoiceType|null
     */
    public function getChangeOrderChoice()
    {
        return $this->ChangeOrderChoice;
    }
    /**
     * Set ChangeOrderChoice value
     * @param \StructType\ChangeOrderChoiceType $changeOrderChoice
     * @return \StructType\OrderChangeRequestType
     */
    public function setChangeOrderChoice(\StructType\ChangeOrderChoiceType $changeOrderChoice = null)
    {
        $this->ChangeOrderChoice = $changeOrderChoice;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\DataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\DataListsType $dataLists
     * @return \StructType\OrderChangeRequestType
     */
    public function setDataLists(\StructType\DataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OrderChangeRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get OrderChangeParameters value
     * @return \StructType\ResponseParametersOrderChangeType|null
     */
    public function getOrderChangeParameters()
    {
        return $this->OrderChangeParameters;
    }
    /**
     * Set OrderChangeParameters value
     * @param \StructType\ResponseParametersOrderChangeType $orderChangeParameters
     * @return \StructType\OrderChangeRequestType
     */
    public function setOrderChangeParameters(\StructType\ResponseParametersOrderChangeType $orderChangeParameters = null)
    {
        $this->OrderChangeParameters = $orderChangeParameters;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType[]|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxGroupForArrayConstraintsFromSetPaxGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderChangeRequestTypePaxGroupItem) {
            // validation for constraint: itemType
            if (!$orderChangeRequestTypePaxGroupItem instanceof \StructType\PaxGroupType) {
                $invalidValues[] = is_object($orderChangeRequestTypePaxGroupItem) ? get_class($orderChangeRequestTypePaxGroupItem) : sprintf('%s(%s)', gettype($orderChangeRequestTypePaxGroupItem), var_export($orderChangeRequestTypePaxGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxGroup property can only contain items of type \StructType\PaxGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxGroupType[] $paxGroup
     * @return \StructType\OrderChangeRequestType
     */
    public function setPaxGroup(array $paxGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($paxGroupArrayErrorMessage = self::validatePaxGroupForArrayConstraintsFromSetPaxGroup($paxGroup))) {
            throw new \InvalidArgumentException($paxGroupArrayErrorMessage, __LINE__);
        }
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Add item to PaxGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PaxGroupType $item
     * @return \StructType\OrderChangeRequestType
     */
    public function addToPaxGroup(\StructType\PaxGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaxGroupType) {
            throw new \InvalidArgumentException(sprintf('The PaxGroup property can only contain items of type \StructType\PaxGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxGroup[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentFunctionsChangeType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderChangeRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$orderChangeRequestTypePaymentFunctionsItem instanceof \StructType\PaymentFunctionsChangeType) {
                $invalidValues[] = is_object($orderChangeRequestTypePaymentFunctionsItem) ? get_class($orderChangeRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($orderChangeRequestTypePaymentFunctionsItem), var_export($orderChangeRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsChangeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsChangeType[] $paymentFunctions
     * @return \StructType\OrderChangeRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentFunctionsChangeType $item
     * @return \StructType\OrderChangeRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentFunctionsChangeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentFunctionsChangeType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentFunctionsChangeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
}
