<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChangeNotifType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payload information for OrderChangeNotifRQ.
 * @subpackage Structs
 */
class OrderChangeNotifType extends AbstractStructBase
{
    /**
     * The ChangeGroup
     * Meta information extracted from the WSDL
     * - documentation: A node containing change operation group
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ChangeGroupType[]
     */
    public $ChangeGroup;
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order ID for which this payment method applies. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderRefID;
    /**
     * The CurrentOrder
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order to which the change operations above need to be applied. Once fully updated, the version of the Order would correspond to the version of the last ChangeGroup in this batch of changes (OrderChangeNotifRQ).
     * Required by Sellers who are unable to store the Orders sent to them by Airlines. Also used by Airlines unable to persist IDs or reproduce IDs consistently between Order responses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderSnapshotType
     */
    public $CurrentOrder;
    /**
     * The OrderBaseline
     * Meta information extracted from the WSDL
     * - documentation: Version of the Order to which the change operations above need to be applied. Once fully updated, the version of the Order would correspond to the version of the last ChangeGroup in this batch of changes (OrderChangeNotifRQ).
     * Required by Sellers who are unable to store the Orders sent to them by Airlines. Also used by Airlines unable to persist IDs or reproduce IDs consistently between Order responses.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OrderSnapshotType
     */
    public $OrderBaseline;
    /**
     * Constructor method for OrderChangeNotifType
     * @uses OrderChangeNotifType::setChangeGroup()
     * @uses OrderChangeNotifType::setOrderRefID()
     * @uses OrderChangeNotifType::setCurrentOrder()
     * @uses OrderChangeNotifType::setOrderBaseline()
     * @param \StructType\ChangeGroupType[] $changeGroup
     * @param string $orderRefID
     * @param \StructType\OrderSnapshotType $currentOrder
     * @param \StructType\OrderSnapshotType $orderBaseline
     */
    public function __construct(array $changeGroup = array(), $orderRefID = null, \StructType\OrderSnapshotType $currentOrder = null, \StructType\OrderSnapshotType $orderBaseline = null)
    {
        $this
            ->setChangeGroup($changeGroup)
            ->setOrderRefID($orderRefID)
            ->setCurrentOrder($currentOrder)
            ->setOrderBaseline($orderBaseline);
    }
    /**
     * Get ChangeGroup value
     * @return \StructType\ChangeGroupType[]
     */
    public function getChangeGroup()
    {
        return $this->ChangeGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeGroupForArrayConstraintsFromSetChangeGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $orderChangeNotifTypeChangeGroupItem) {
            // validation for constraint: itemType
            if (!$orderChangeNotifTypeChangeGroupItem instanceof \StructType\ChangeGroupType) {
                $invalidValues[] = is_object($orderChangeNotifTypeChangeGroupItem) ? get_class($orderChangeNotifTypeChangeGroupItem) : sprintf('%s(%s)', gettype($orderChangeNotifTypeChangeGroupItem), var_export($orderChangeNotifTypeChangeGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ChangeGroup property can only contain items of type \StructType\ChangeGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeGroupType[] $changeGroup
     * @return \StructType\OrderChangeNotifType
     */
    public function setChangeGroup(array $changeGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($changeGroupArrayErrorMessage = self::validateChangeGroupForArrayConstraintsFromSetChangeGroup($changeGroup))) {
            throw new \InvalidArgumentException($changeGroupArrayErrorMessage, __LINE__);
        }
        $this->ChangeGroup = $changeGroup;
        return $this;
    }
    /**
     * Add item to ChangeGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ChangeGroupType $item
     * @return \StructType\OrderChangeNotifType
     */
    public function addToChangeGroup(\StructType\ChangeGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ChangeGroupType) {
            throw new \InvalidArgumentException(sprintf('The ChangeGroup property can only contain items of type \StructType\ChangeGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ChangeGroup[] = $item;
        return $this;
    }
    /**
     * Get OrderRefID value
     * @return string
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\OrderChangeNotifType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
    /**
     * Get CurrentOrder value
     * @return \StructType\OrderSnapshotType|null
     */
    public function getCurrentOrder()
    {
        return $this->CurrentOrder;
    }
    /**
     * Set CurrentOrder value
     * @param \StructType\OrderSnapshotType $currentOrder
     * @return \StructType\OrderChangeNotifType
     */
    public function setCurrentOrder(\StructType\OrderSnapshotType $currentOrder = null)
    {
        $this->CurrentOrder = $currentOrder;
        return $this;
    }
    /**
     * Get OrderBaseline value
     * @return \StructType\OrderSnapshotType|null
     */
    public function getOrderBaseline()
    {
        return $this->OrderBaseline;
    }
    /**
     * Set OrderBaseline value
     * @param \StructType\OrderSnapshotType $orderBaseline
     * @return \StructType\OrderChangeNotifType
     */
    public function setOrderBaseline(\StructType\OrderSnapshotType $orderBaseline = null)
    {
        $this->OrderBaseline = $orderBaseline;
        return $this;
    }
}
