<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Operation StructType
 * @subpackage Structs
 */
class Operation extends AbstractStructBase
{
    /**
     * The Adjustment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Adjustment
     */
    public $Adjustment;
    /**
     * The Designator
     * Meta information extracted from the WSDL
     * - documentation: Operation code. Example: Discount code
     * - minOccurs: 0
     * @var string
     */
    public $Designator;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - documentation: Operation reason
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * The DescriptionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DescriptionDetails
     */
    public $DescriptionDetails;
    /**
     * The SequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Sequence number
     * @var string
     */
    public $SequenceNumber;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * @var string
     */
    public $DocumentNumber;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Type of Operation. Example: Discount
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Operation
     * @uses Operation::setAdjustment()
     * @uses Operation::setDesignator()
     * @uses Operation::setReason()
     * @uses Operation::setDescriptionDetails()
     * @uses Operation::setSequenceNumber()
     * @uses Operation::setDocumentNumber()
     * @uses Operation::setType()
     * @param \StructType\Adjustment $adjustment
     * @param string $designator
     * @param string $reason
     * @param \StructType\DescriptionDetails $descriptionDetails
     * @param string $sequenceNumber
     * @param string $documentNumber
     * @param string $type
     */
    public function __construct(\StructType\Adjustment $adjustment = null, $designator = null, $reason = null, \StructType\DescriptionDetails $descriptionDetails = null, $sequenceNumber = null, $documentNumber = null, $type = null)
    {
        $this
            ->setAdjustment($adjustment)
            ->setDesignator($designator)
            ->setReason($reason)
            ->setDescriptionDetails($descriptionDetails)
            ->setSequenceNumber($sequenceNumber)
            ->setDocumentNumber($documentNumber)
            ->setType($type);
    }
    /**
     * Get Adjustment value
     * @return \StructType\Adjustment|null
     */
    public function getAdjustment()
    {
        return $this->Adjustment;
    }
    /**
     * Set Adjustment value
     * @param \StructType\Adjustment $adjustment
     * @return \StructType\Operation
     */
    public function setAdjustment(\StructType\Adjustment $adjustment = null)
    {
        $this->Adjustment = $adjustment;
        return $this;
    }
    /**
     * Get Designator value
     * @return string|null
     */
    public function getDesignator()
    {
        return $this->Designator;
    }
    /**
     * Set Designator value
     * @param string $designator
     * @return \StructType\Operation
     */
    public function setDesignator($designator = null)
    {
        // validation for constraint: string
        if (!is_null($designator) && !is_string($designator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($designator, true), gettype($designator)), __LINE__);
        }
        $this->Designator = $designator;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \StructType\Operation
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
    /**
     * Get DescriptionDetails value
     * @return \StructType\DescriptionDetails|null
     */
    public function getDescriptionDetails()
    {
        return $this->DescriptionDetails;
    }
    /**
     * Set DescriptionDetails value
     * @param \StructType\DescriptionDetails $descriptionDetails
     * @return \StructType\Operation
     */
    public function setDescriptionDetails(\StructType\DescriptionDetails $descriptionDetails = null)
    {
        $this->DescriptionDetails = $descriptionDetails;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param string $sequenceNumber
     * @return \StructType\Operation
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNumber) && !is_string($sequenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNumber, true), gettype($sequenceNumber)), __LINE__);
        }
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \StructType\Operation
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Operation
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
