<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingSegmentCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of attributes of an operating carrier used in search criteria
 * @subpackage Structs
 */
class OperatingSegmentCriteriaType extends AbstractStructBase
{
    /**
     * The CarrierDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $CarrierDesigCode;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The DisclosureRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Disclosure ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisclosureRefID;
    /**
     * The OperatingCarrierFlightNumberText
     * Meta information extracted from the WSDL
     * - documentation: The numerical designation of a flight as it is operated by a carrier. | Identifies a flight number. 1 to 4 digits. May or may not have leading zeros when less than 4 digits. The use of leading zeros does not create a different Flight
     * Number. For example, Flight Numbers 123 and 0123 are the same.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{1,4}
     * @var string
     */
    public $OperatingCarrierFlightNumberText;
    /**
     * The OperationalSuffixText
     * Meta information extracted from the WSDL
     * - documentation: Used to distinguish two flights having the same flight number and departing from their respective Origin Stations on the same date. | Defines the Operational Suffix which is appended to a flight number.
     * - base: xs:string
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationalSuffixText;
    /**
     * The RBD_Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify a particular RBD (e.g. P, J, W, M, etc.). | Enumeration values of RBD Codes as per PADIS codeset 9800. {codeListAgencyName}IATA{/codeListAgencyName} {codeListIdentifier}PADIS 9800{/codeListIdentifier} |
     * Additional BDT to specify the RBD as defined in AIRIMP and SSIM.
     * - base: RBD_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RBD_Code;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - documentation: Flight Status, examples: SO, Flight Canceled. Refer PADIS codeset 1245. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * Constructor method for OperatingSegmentCriteriaType
     * @uses OperatingSegmentCriteriaType::setCarrierDesigCode()
     * @uses OperatingSegmentCriteriaType::setCarrierName()
     * @uses OperatingSegmentCriteriaType::setDisclosureRefID()
     * @uses OperatingSegmentCriteriaType::setOperatingCarrierFlightNumberText()
     * @uses OperatingSegmentCriteriaType::setOperationalSuffixText()
     * @uses OperatingSegmentCriteriaType::setRBD_Code()
     * @uses OperatingSegmentCriteriaType::setStatusCode()
     * @param string $carrierDesigCode
     * @param string $carrierName
     * @param string $disclosureRefID
     * @param string $operatingCarrierFlightNumberText
     * @param string $operationalSuffixText
     * @param string $rBD_Code
     * @param string $statusCode
     */
    public function __construct($carrierDesigCode = null, $carrierName = null, $disclosureRefID = null, $operatingCarrierFlightNumberText = null, $operationalSuffixText = null, $rBD_Code = null, $statusCode = null)
    {
        $this
            ->setCarrierDesigCode($carrierDesigCode)
            ->setCarrierName($carrierName)
            ->setDisclosureRefID($disclosureRefID)
            ->setOperatingCarrierFlightNumberText($operatingCarrierFlightNumberText)
            ->setOperationalSuffixText($operationalSuffixText)
            ->setRBD_Code($rBD_Code)
            ->setStatusCode($statusCode);
    }
    /**
     * Get CarrierDesigCode value
     * @return string
     */
    public function getCarrierDesigCode()
    {
        return $this->CarrierDesigCode;
    }
    /**
     * Set CarrierDesigCode value
     * @param string $carrierDesigCode
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setCarrierDesigCode($carrierDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierDesigCode) && !is_string($carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierDesigCode, true), gettype($carrierDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($carrierDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($carrierDesigCode, true)), __LINE__);
        }
        $this->CarrierDesigCode = $carrierDesigCode;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get DisclosureRefID value
     * @return string|null
     */
    public function getDisclosureRefID()
    {
        return $this->DisclosureRefID;
    }
    /**
     * Set DisclosureRefID value
     * @param string $disclosureRefID
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setDisclosureRefID($disclosureRefID = null)
    {
        // validation for constraint: string
        if (!is_null($disclosureRefID) && !is_string($disclosureRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($disclosureRefID, true), gettype($disclosureRefID)), __LINE__);
        }
        $this->DisclosureRefID = $disclosureRefID;
        return $this;
    }
    /**
     * Get OperatingCarrierFlightNumberText value
     * @return string|null
     */
    public function getOperatingCarrierFlightNumberText()
    {
        return $this->OperatingCarrierFlightNumberText;
    }
    /**
     * Set OperatingCarrierFlightNumberText value
     * @param string $operatingCarrierFlightNumberText
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setOperatingCarrierFlightNumberText($operatingCarrierFlightNumberText = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierFlightNumberText) && !is_string($operatingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierFlightNumberText, true), gettype($operatingCarrierFlightNumberText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,4})
        if (!is_null($operatingCarrierFlightNumberText) && !preg_match('/[0-9]{1,4}/', $operatingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,4}', var_export($operatingCarrierFlightNumberText, true)), __LINE__);
        }
        $this->OperatingCarrierFlightNumberText = $operatingCarrierFlightNumberText;
        return $this;
    }
    /**
     * Get OperationalSuffixText value
     * @return string|null
     */
    public function getOperationalSuffixText()
    {
        return $this->OperationalSuffixText;
    }
    /**
     * Set OperationalSuffixText value
     * @param string $operationalSuffixText
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setOperationalSuffixText($operationalSuffixText = null)
    {
        // validation for constraint: string
        if (!is_null($operationalSuffixText) && !is_string($operationalSuffixText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationalSuffixText, true), gettype($operationalSuffixText)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($operationalSuffixText) && mb_strlen($operationalSuffixText) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($operationalSuffixText)), __LINE__);
        }
        $this->OperationalSuffixText = $operationalSuffixText;
        return $this;
    }
    /**
     * Get RBD_Code value
     * @return string|null
     */
    public function getRBD_Code()
    {
        return $this->RBD_Code;
    }
    /**
     * Set RBD_Code value
     * @param string $rBD_Code
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setRBD_Code($rBD_Code = null)
    {
        // validation for constraint: string
        if (!is_null($rBD_Code) && !is_string($rBD_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rBD_Code, true), gettype($rBD_Code)), __LINE__);
        }
        $this->RBD_Code = $rBD_Code;
        return $this;
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \StructType\OperatingSegmentCriteriaType
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
}
