<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffersSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer summary that includes highest, lowest, and number of matched offers included in the response.
 * @subpackage Structs
 */
class OffersSummaryType extends AbstractStructBase
{
    /**
     * The HighestOfferPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something .
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceSummaryType
     */
    public $HighestOfferPrice;
    /**
     * The LowestOfferPrice
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something .
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceSummaryType
     */
    public $LowestOfferPrice;
    /**
     * The MatchedOfferQty
     * Meta information extracted from the WSDL
     * - documentation: A Quantity of an Offer summary that includes highest, lowest, and number of matched offers included in the response. | A quantity is a counted number of non-monetary units, possibly including fractions
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $MatchedOfferQty;
    /**
     * Constructor method for OffersSummaryType
     * @uses OffersSummaryType::setHighestOfferPrice()
     * @uses OffersSummaryType::setLowestOfferPrice()
     * @uses OffersSummaryType::setMatchedOfferQty()
     * @param \StructType\PriceSummaryType $highestOfferPrice
     * @param \StructType\PriceSummaryType $lowestOfferPrice
     * @param float $matchedOfferQty
     */
    public function __construct(\StructType\PriceSummaryType $highestOfferPrice = null, \StructType\PriceSummaryType $lowestOfferPrice = null, $matchedOfferQty = null)
    {
        $this
            ->setHighestOfferPrice($highestOfferPrice)
            ->setLowestOfferPrice($lowestOfferPrice)
            ->setMatchedOfferQty($matchedOfferQty);
    }
    /**
     * Get HighestOfferPrice value
     * @return \StructType\PriceSummaryType|null
     */
    public function getHighestOfferPrice()
    {
        return $this->HighestOfferPrice;
    }
    /**
     * Set HighestOfferPrice value
     * @param \StructType\PriceSummaryType $highestOfferPrice
     * @return \StructType\OffersSummaryType
     */
    public function setHighestOfferPrice(\StructType\PriceSummaryType $highestOfferPrice = null)
    {
        $this->HighestOfferPrice = $highestOfferPrice;
        return $this;
    }
    /**
     * Get LowestOfferPrice value
     * @return \StructType\PriceSummaryType|null
     */
    public function getLowestOfferPrice()
    {
        return $this->LowestOfferPrice;
    }
    /**
     * Set LowestOfferPrice value
     * @param \StructType\PriceSummaryType $lowestOfferPrice
     * @return \StructType\OffersSummaryType
     */
    public function setLowestOfferPrice(\StructType\PriceSummaryType $lowestOfferPrice = null)
    {
        $this->LowestOfferPrice = $lowestOfferPrice;
        return $this;
    }
    /**
     * Get MatchedOfferQty value
     * @return float|null
     */
    public function getMatchedOfferQty()
    {
        return $this->MatchedOfferQty;
    }
    /**
     * Set MatchedOfferQty value
     * @param float $matchedOfferQty
     * @return \StructType\OffersSummaryType
     */
    public function setMatchedOfferQty($matchedOfferQty = null)
    {
        // validation for constraint: float
        if (!is_null($matchedOfferQty) && !(is_float($matchedOfferQty) || is_numeric($matchedOfferQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchedOfferQty, true), gettype($matchedOfferQty)), __LINE__);
        }
        $this->MatchedOfferQty = $matchedOfferQty;
        return $this;
    }
}
