<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferServiceAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer Service Association
 * @subpackage Structs
 */
class OfferServiceAssociationType extends AbstractStructBase
{
    /**
     * The PaxJourneyRef
     * Meta information extracted from the WSDL
     * - documentation: A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier available)
     * - choice: PaxJourneyRef | SeatAssignment | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxJourneyRefType
     */
    public $PaxJourneyRef;
    /**
     * The SeatAssignment
     * Meta information extracted from the WSDL
     * - documentation: The Seat Location selected by the Passenger (via SeatAvailability) or assigned tot he Passenger by the Airline for a given segment. When used, only a single Passenger must be referenced within the Service.
     * - choice: PaxJourneyRef | SeatAssignment | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SeatAssignmentType
     */
    public $SeatAssignment;
    /**
     * The ServiceDefinitionRef
     * Meta information extracted from the WSDL
     * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * - choice: PaxJourneyRef | SeatAssignment | ServiceDefinitionRef
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OfferServiceDefinitionRefType
     */
    public $ServiceDefinitionRef;
    /**
     * Constructor method for OfferServiceAssociationType
     * @uses OfferServiceAssociationType::setPaxJourneyRef()
     * @uses OfferServiceAssociationType::setSeatAssignment()
     * @uses OfferServiceAssociationType::setServiceDefinitionRef()
     * @param \StructType\PaxJourneyRefType $paxJourneyRef
     * @param \StructType\SeatAssignmentType $seatAssignment
     * @param \StructType\OfferServiceDefinitionRefType $serviceDefinitionRef
     */
    public function __construct(\StructType\PaxJourneyRefType $paxJourneyRef = null, \StructType\SeatAssignmentType $seatAssignment = null, \StructType\OfferServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        $this
            ->setPaxJourneyRef($paxJourneyRef)
            ->setSeatAssignment($seatAssignment)
            ->setServiceDefinitionRef($serviceDefinitionRef);
    }
    /**
     * Get PaxJourneyRef value
     * @return \StructType\PaxJourneyRefType
     */
    public function getPaxJourneyRef()
    {
        return isset($this->PaxJourneyRef) ? $this->PaxJourneyRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxJourneyRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourneyRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxJourneyRefForChoiceConstraintsFromSetPaxJourneyRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'SeatAssignment',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxJourneyRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxJourneyRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxJourneyRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxJourneyRefType $paxJourneyRef
     * @return \StructType\OfferServiceAssociationType
     */
    public function setPaxJourneyRef(\StructType\PaxJourneyRefType $paxJourneyRef = null)
    {
        // validation for constraint: choice(PaxJourneyRef, SeatAssignment, ServiceDefinitionRef)
        if ('' !== ($paxJourneyRefChoiceErrorMessage = self::validatePaxJourneyRefForChoiceConstraintsFromSetPaxJourneyRef($paxJourneyRef))) {
            throw new \InvalidArgumentException($paxJourneyRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxJourneyRef) || (is_array($paxJourneyRef) && empty($paxJourneyRef))) {
            unset($this->PaxJourneyRef);
        } else {
            $this->PaxJourneyRef = $paxJourneyRef;
        }
        return $this;
    }
    /**
     * Get SeatAssignment value
     * @return \StructType\SeatAssignmentType
     */
    public function getSeatAssignment()
    {
        return isset($this->SeatAssignment) ? $this->SeatAssignment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSeatAssignment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatAssignment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeatAssignmentForChoiceConstraintsFromSetSeatAssignment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxJourneyRef',
            'ServiceDefinitionRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeatAssignment can\'t be set as the property %s is already set. Only one property must be set among these properties: SeatAssignment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeatAssignment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SeatAssignmentType $seatAssignment
     * @return \StructType\OfferServiceAssociationType
     */
    public function setSeatAssignment(\StructType\SeatAssignmentType $seatAssignment = null)
    {
        // validation for constraint: choice(PaxJourneyRef, SeatAssignment, ServiceDefinitionRef)
        if ('' !== ($seatAssignmentChoiceErrorMessage = self::validateSeatAssignmentForChoiceConstraintsFromSetSeatAssignment($seatAssignment))) {
            throw new \InvalidArgumentException($seatAssignmentChoiceErrorMessage, __LINE__);
        }
        if (is_null($seatAssignment) || (is_array($seatAssignment) && empty($seatAssignment))) {
            unset($this->SeatAssignment);
        } else {
            $this->SeatAssignment = $seatAssignment;
        }
        return $this;
    }
    /**
     * Get ServiceDefinitionRef value
     * @return \StructType\OfferServiceDefinitionRefType
     */
    public function getServiceDefinitionRef()
    {
        return isset($this->ServiceDefinitionRef) ? $this->ServiceDefinitionRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceDefinitionRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceDefinitionRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxJourneyRef',
            'SeatAssignment',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceDefinitionRef can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceDefinitionRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceDefinitionRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OfferServiceDefinitionRefType $serviceDefinitionRef
     * @return \StructType\OfferServiceAssociationType
     */
    public function setServiceDefinitionRef(\StructType\OfferServiceDefinitionRefType $serviceDefinitionRef = null)
    {
        // validation for constraint: choice(PaxJourneyRef, SeatAssignment, ServiceDefinitionRef)
        if ('' !== ($serviceDefinitionRefChoiceErrorMessage = self::validateServiceDefinitionRefForChoiceConstraintsFromSetServiceDefinitionRef($serviceDefinitionRef))) {
            throw new \InvalidArgumentException($serviceDefinitionRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceDefinitionRef) || (is_array($serviceDefinitionRef) && empty($serviceDefinitionRef))) {
            unset($this->ServiceDefinitionRef);
        } else {
            $this->ServiceDefinitionRef = $serviceDefinitionRef;
        }
        return $this;
    }
}
