<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferItemTimeLimitsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Time limit for an offer item.
 * @subpackage Structs
 */
class OfferItemTimeLimitsType extends AbstractStructBase
{
    /**
     * The PriceGuaranteeTimeLimitDateTime
     * Meta information extracted from the WSDL
     * - documentation: The date beyond which a price is no longer guaranteed. Examples: 2015-01-13T13:59:38Z | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of
     * second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceGuaranteeTimeLimitDateTime;
    /**
     * Constructor method for OfferItemTimeLimitsType
     * @uses OfferItemTimeLimitsType::setPriceGuaranteeTimeLimitDateTime()
     * @param string $priceGuaranteeTimeLimitDateTime
     */
    public function __construct($priceGuaranteeTimeLimitDateTime = null)
    {
        $this
            ->setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime);
    }
    /**
     * Get PriceGuaranteeTimeLimitDateTime value
     * @return string|null
     */
    public function getPriceGuaranteeTimeLimitDateTime()
    {
        return $this->PriceGuaranteeTimeLimitDateTime;
    }
    /**
     * Set PriceGuaranteeTimeLimitDateTime value
     * @param string $priceGuaranteeTimeLimitDateTime
     * @return \StructType\OfferItemTimeLimitsType
     */
    public function setPriceGuaranteeTimeLimitDateTime($priceGuaranteeTimeLimitDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($priceGuaranteeTimeLimitDateTime) && !is_string($priceGuaranteeTimeLimitDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceGuaranteeTimeLimitDateTime, true), gettype($priceGuaranteeTimeLimitDateTime)), __LINE__);
        }
        $this->PriceGuaranteeTimeLimitDateTime = $priceGuaranteeTimeLimitDateTime;
        return $this;
    }
}
