<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferFlightAssociationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer Flight Associations
 * @subpackage Structs
 */
class OfferFlightAssociationsType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRef
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Dated Operating Leg within this message
     * - choice: DatedOperatingLegRef | PaxJourneyRef | PaxSegmentReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DatedOperatingLegRefType
     */
    public $DatedOperatingLegRef;
    /**
     * The PaxJourneyRef
     * Meta information extracted from the WSDL
     * - documentation: A collection of segments which satisfies transportation of a passenger for a given origin and destination. Business Identifier Fields: - (no identifier available)
     * - choice: DatedOperatingLegRef | PaxJourneyRef | PaxSegmentReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxJourneyRefType
     */
    public $PaxJourneyRef;
    /**
     * The PaxSegmentReferences
     * Meta information extracted from the WSDL
     * - documentation: Reference to a PaxSegmentID's - 1 or more pax segments references. These references will be to a data list or pax segment list in the contained message.
     * - choice: DatedOperatingLegRef | PaxJourneyRef | PaxSegmentReferences
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxSegmentRefListType
     */
    public $PaxSegmentReferences;
    /**
     * Constructor method for OfferFlightAssociationsType
     * @uses OfferFlightAssociationsType::setDatedOperatingLegRef()
     * @uses OfferFlightAssociationsType::setPaxJourneyRef()
     * @uses OfferFlightAssociationsType::setPaxSegmentReferences()
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @param \StructType\PaxJourneyRefType $paxJourneyRef
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     */
    public function __construct(\StructType\DatedOperatingLegRefType $datedOperatingLegRef = null, \StructType\PaxJourneyRefType $paxJourneyRef = null, \StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        $this
            ->setDatedOperatingLegRef($datedOperatingLegRef)
            ->setPaxJourneyRef($paxJourneyRef)
            ->setPaxSegmentReferences($paxSegmentReferences);
    }
    /**
     * Get DatedOperatingLegRef value
     * @return \StructType\DatedOperatingLegRefType
     */
    public function getDatedOperatingLegRef()
    {
        return isset($this->DatedOperatingLegRef) ? $this->DatedOperatingLegRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDatedOperatingLegRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDatedOperatingLegRefForChoiceConstraintsFromSetDatedOperatingLegRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaxJourneyRef',
            'PaxSegmentReferences',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DatedOperatingLegRef can\'t be set as the property %s is already set. Only one property must be set among these properties: DatedOperatingLegRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DatedOperatingLegRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegRefType $datedOperatingLegRef
     * @return \StructType\OfferFlightAssociationsType
     */
    public function setDatedOperatingLegRef(\StructType\DatedOperatingLegRefType $datedOperatingLegRef = null)
    {
        // validation for constraint: choice(DatedOperatingLegRef, PaxJourneyRef, PaxSegmentReferences)
        if ('' !== ($datedOperatingLegRefChoiceErrorMessage = self::validateDatedOperatingLegRefForChoiceConstraintsFromSetDatedOperatingLegRef($datedOperatingLegRef))) {
            throw new \InvalidArgumentException($datedOperatingLegRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($datedOperatingLegRef) || (is_array($datedOperatingLegRef) && empty($datedOperatingLegRef))) {
            unset($this->DatedOperatingLegRef);
        } else {
            $this->DatedOperatingLegRef = $datedOperatingLegRef;
        }
        return $this;
    }
    /**
     * Get PaxJourneyRef value
     * @return \StructType\PaxJourneyRefType
     */
    public function getPaxJourneyRef()
    {
        return isset($this->PaxJourneyRef) ? $this->PaxJourneyRef : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxJourneyRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxJourneyRef method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxJourneyRefForChoiceConstraintsFromSetPaxJourneyRef($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DatedOperatingLegRef',
            'PaxSegmentReferences',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxJourneyRef can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxJourneyRef, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxJourneyRef value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxJourneyRefType $paxJourneyRef
     * @return \StructType\OfferFlightAssociationsType
     */
    public function setPaxJourneyRef(\StructType\PaxJourneyRefType $paxJourneyRef = null)
    {
        // validation for constraint: choice(DatedOperatingLegRef, PaxJourneyRef, PaxSegmentReferences)
        if ('' !== ($paxJourneyRefChoiceErrorMessage = self::validatePaxJourneyRefForChoiceConstraintsFromSetPaxJourneyRef($paxJourneyRef))) {
            throw new \InvalidArgumentException($paxJourneyRefChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxJourneyRef) || (is_array($paxJourneyRef) && empty($paxJourneyRef))) {
            unset($this->PaxJourneyRef);
        } else {
            $this->PaxJourneyRef = $paxJourneyRef;
        }
        return $this;
    }
    /**
     * Get PaxSegmentReferences value
     * @return \StructType\PaxSegmentRefListType
     */
    public function getPaxSegmentReferences()
    {
        return isset($this->PaxSegmentReferences) ? $this->PaxSegmentReferences : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaxSegmentReferences method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxSegmentReferences method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaxSegmentReferencesForChoiceConstraintsFromSetPaxSegmentReferences($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DatedOperatingLegRef',
            'PaxJourneyRef',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaxSegmentReferences can\'t be set as the property %s is already set. Only one property must be set among these properties: PaxSegmentReferences, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaxSegmentReferences value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaxSegmentRefListType $paxSegmentReferences
     * @return \StructType\OfferFlightAssociationsType
     */
    public function setPaxSegmentReferences(\StructType\PaxSegmentRefListType $paxSegmentReferences = null)
    {
        // validation for constraint: choice(DatedOperatingLegRef, PaxJourneyRef, PaxSegmentReferences)
        if ('' !== ($paxSegmentReferencesChoiceErrorMessage = self::validatePaxSegmentReferencesForChoiceConstraintsFromSetPaxSegmentReferences($paxSegmentReferences))) {
            throw new \InvalidArgumentException($paxSegmentReferencesChoiceErrorMessage, __LINE__);
        }
        if (is_null($paxSegmentReferences) || (is_array($paxSegmentReferences) && empty($paxSegmentReferences))) {
            unset($this->PaxSegmentReferences);
        } else {
            $this->PaxSegmentReferences = $paxSegmentReferences;
        }
        return $this;
    }
}
