<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferAssociationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Associations to Offers and Offer Items. | A set of associations to Offers and Offer Items.
 * @subpackage Structs
 */
class OfferAssociationType extends AbstractStructBase
{
    /**
     * The OfferRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer ID for which the payment preference applies. | Reference to an Offer ID for which the payment method applies. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferRefID;
    /**
     * The OwnerCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $OwnerCode;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Offer Item ID for which the payment preference applies. | Reference to an Offer Item ID for which the payment method applies | An identifier is a character string used to uniquely identify one instance of an object
     * within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $OfferItemRefID;
    /**
     * Constructor method for OfferAssociationType
     * @uses OfferAssociationType::setOfferRefID()
     * @uses OfferAssociationType::setOwnerCode()
     * @uses OfferAssociationType::setOfferItemRefID()
     * @param string $offerRefID
     * @param string $ownerCode
     * @param string[] $offerItemRefID
     */
    public function __construct($offerRefID = null, $ownerCode = null, array $offerItemRefID = array())
    {
        $this
            ->setOfferRefID($offerRefID)
            ->setOwnerCode($ownerCode)
            ->setOfferItemRefID($offerItemRefID);
    }
    /**
     * Get OfferRefID value
     * @return string
     */
    public function getOfferRefID()
    {
        return $this->OfferRefID;
    }
    /**
     * Set OfferRefID value
     * @param string $offerRefID
     * @return \StructType\OfferAssociationType
     */
    public function setOfferRefID($offerRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerRefID) && !is_string($offerRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerRefID, true), gettype($offerRefID)), __LINE__);
        }
        $this->OfferRefID = $offerRefID;
        return $this;
    }
    /**
     * Get OwnerCode value
     * @return string
     */
    public function getOwnerCode()
    {
        return $this->OwnerCode;
    }
    /**
     * Set OwnerCode value
     * @param string $ownerCode
     * @return \StructType\OfferAssociationType
     */
    public function setOwnerCode($ownerCode = null)
    {
        // validation for constraint: string
        if (!is_null($ownerCode) && !is_string($ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerCode, true), gettype($ownerCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($ownerCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $ownerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($ownerCode, true)), __LINE__);
        }
        $this->OwnerCode = $ownerCode;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string[]|null
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerAssociationTypeOfferItemRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($offerAssociationTypeOfferItemRefIDItem)) {
                $invalidValues[] = is_object($offerAssociationTypeOfferItemRefIDItem) ? get_class($offerAssociationTypeOfferItemRefIDItem) : sprintf('%s(%s)', gettype($offerAssociationTypeOfferItemRefIDItem), var_export($offerAssociationTypeOfferItemRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItemRefID value
     * @throws \InvalidArgumentException
     * @param string[] $offerItemRefID
     * @return \StructType\OfferAssociationType
     */
    public function setOfferItemRefID(array $offerItemRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemRefIDArrayErrorMessage = self::validateOfferItemRefIDForArrayConstraintsFromSetOfferItemRefID($offerItemRefID))) {
            throw new \InvalidArgumentException($offerItemRefIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($offerItemRefID) && count($offerItemRefID) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Add item to OfferItemRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OfferAssociationType
     */
    public function addToOfferItemRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OfferItemRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OfferItemRefID) && count($this->OfferItemRefID) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OfferItemRefID)), __LINE__);
        }
        $this->OfferItemRefID[] = $item;
        return $this;
    }
}
