<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the reference to the Offer received from the redemption engine - not to be confused with the NDC Offer
 * @subpackage Structs
 */
class Offer extends AbstractStructBase
{
    /**
     * The OfferCodeID
     * Meta information extracted from the WSDL
     * - documentation: ID for this offer as filed in rules engineExample: 0AR123
     * @var string
     */
    public $OfferCodeID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * The UnitControl
     * @var \StructType\UnitControl
     */
    public $UnitControl;
    /**
     * Constructor method for Offer
     * @uses Offer::setOfferCodeID()
     * @uses Offer::setDescription()
     * @uses Offer::setUnitControl()
     * @param string $offerCodeID
     * @param mixed $description
     * @param \StructType\UnitControl $unitControl
     */
    public function __construct($offerCodeID = null, $description = null, \StructType\UnitControl $unitControl = null)
    {
        $this
            ->setOfferCodeID($offerCodeID)
            ->setDescription($description)
            ->setUnitControl($unitControl);
    }
    /**
     * Get OfferCodeID value
     * @return string|null
     */
    public function getOfferCodeID()
    {
        return $this->OfferCodeID;
    }
    /**
     * Set OfferCodeID value
     * @param string $offerCodeID
     * @return \StructType\Offer
     */
    public function setOfferCodeID($offerCodeID = null)
    {
        // validation for constraint: string
        if (!is_null($offerCodeID) && !is_string($offerCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerCodeID, true), gettype($offerCodeID)), __LINE__);
        }
        $this->OfferCodeID = $offerCodeID;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\Offer
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UnitControl value
     * @return \StructType\UnitControl|null
     */
    public function getUnitControl()
    {
        return $this->UnitControl;
    }
    /**
     * Set UnitControl value
     * @param \StructType\UnitControl $unitControl
     * @return \StructType\Offer
     */
    public function setUnitControl(\StructType\UnitControl $unitControl = null)
    {
        $this->UnitControl = $unitControl;
        return $this;
    }
}
