<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewPrice StructType
 * Meta information extracted from the WSDL
 * - documentation: A container for Price and Fare detail information.
 * @subpackage Structs
 */
class NewPrice extends AbstractStructBase
{
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - minOccurs: 0
     * @var \StructType\FareDetailType
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * Constructor method for NewPrice
     * @uses NewPrice::setFareDetail()
     * @uses NewPrice::setPrice()
     * @param \StructType\FareDetailType $fareDetail
     * @param \StructType\PriceType $price
     */
    public function __construct(\StructType\FareDetailType $fareDetail = null, \StructType\PriceType $price = null)
    {
        $this
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * Set FareDetail value
     * @param \StructType\FareDetailType $fareDetail
     * @return \StructType\NewPrice
     */
    public function setFareDetail(\StructType\FareDetailType $fareDetail = null)
    {
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\NewPrice
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
