<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantAccountType StructType
 * Meta information extracted from the WSDL
 * - documentation: A person or company that sells goods or services. | A person or company that sells goods or services. A merchant works with an Acquiring Bank to apply for and receive a Merchant Account (an account that allows the Merchant to accept
 * Credit and debit cards). Whenever a customer purchases an item with a Credit or debit card, the Merchant submits the purchase Transaction information to its Acquiring Bank, which will then submit it through the card association network to the card
 * holder's Issuing Bank. The Issuing Bank will approve or decline the charge, and bill the cardholder the amount due to the Merchant.
 * @subpackage Structs
 */
class MerchantAccountType extends AbstractStructBase
{
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. | The organization which carries the
     * passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - documentation: A nation with its own government, occupying a particular territory.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CountryType
     */
    public $Country;
    /**
     * The MerchantCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: specifies the merchant category. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantCategoryCode;
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - documentation: identifier passed from the merchant (airline) to the PSP/Bank to identify themselves during the authorization transaction. | An identifier is a character string used to uniquely identify one instance of an object within an
     * identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantID;
    /**
     * The MerchantName
     * Meta information extracted from the WSDL
     * - documentation: name under which the merchant is registered within their PSP/Bank | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantName;
    /**
     * The MerchantRiskText
     * Meta information extracted from the WSDL
     * - documentation: indicates the merchantÂ´s risk. | indicates the merchant's risk. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MerchantRiskText;
    /**
     * Constructor method for MerchantAccountType
     * @uses MerchantAccountType::setCarrier()
     * @uses MerchantAccountType::setCountry()
     * @uses MerchantAccountType::setMerchantCategoryCode()
     * @uses MerchantAccountType::setMerchantID()
     * @uses MerchantAccountType::setMerchantName()
     * @uses MerchantAccountType::setMerchantRiskText()
     * @param \StructType\CarrierType $carrier
     * @param \StructType\CountryType $country
     * @param string $merchantCategoryCode
     * @param string $merchantID
     * @param string $merchantName
     * @param string $merchantRiskText
     */
    public function __construct(\StructType\CarrierType $carrier = null, \StructType\CountryType $country = null, $merchantCategoryCode = null, $merchantID = null, $merchantName = null, $merchantRiskText = null)
    {
        $this
            ->setCarrier($carrier)
            ->setCountry($country)
            ->setMerchantCategoryCode($merchantCategoryCode)
            ->setMerchantID($merchantID)
            ->setMerchantName($merchantName)
            ->setMerchantRiskText($merchantRiskText);
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\CarrierType $carrier
     * @return \StructType\MerchantAccountType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get Country value
     * @return \StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \StructType\CountryType $country
     * @return \StructType\MerchantAccountType
     */
    public function setCountry(\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get MerchantCategoryCode value
     * @return string|null
     */
    public function getMerchantCategoryCode()
    {
        return $this->MerchantCategoryCode;
    }
    /**
     * Set MerchantCategoryCode value
     * @param string $merchantCategoryCode
     * @return \StructType\MerchantAccountType
     */
    public function setMerchantCategoryCode($merchantCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantCategoryCode) && !is_string($merchantCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantCategoryCode, true), gettype($merchantCategoryCode)), __LINE__);
        }
        $this->MerchantCategoryCode = $merchantCategoryCode;
        return $this;
    }
    /**
     * Get MerchantID value
     * @return string|null
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \StructType\MerchantAccountType
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get MerchantName value
     * @return string|null
     */
    public function getMerchantName()
    {
        return $this->MerchantName;
    }
    /**
     * Set MerchantName value
     * @param string $merchantName
     * @return \StructType\MerchantAccountType
     */
    public function setMerchantName($merchantName = null)
    {
        // validation for constraint: string
        if (!is_null($merchantName) && !is_string($merchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantName, true), gettype($merchantName)), __LINE__);
        }
        $this->MerchantName = $merchantName;
        return $this;
    }
    /**
     * Get MerchantRiskText value
     * @return string|null
     */
    public function getMerchantRiskText()
    {
        return $this->MerchantRiskText;
    }
    /**
     * Set MerchantRiskText value
     * @param string $merchantRiskText
     * @return \StructType\MerchantAccountType
     */
    public function setMerchantRiskText($merchantRiskText = null)
    {
        // validation for constraint: string
        if (!is_null($merchantRiskText) && !is_string($merchantRiskText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantRiskText, true), gettype($merchantRiskText)), __LINE__);
        }
        $this->MerchantRiskText = $merchantRiskText;
        return $this;
    }
}
