<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Markup StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the reason for the markup added by an airline as part of the offer reported as calculation detail. The amount added to the cost price of goods to cover overhead and profit. [Oxford]
 * @subpackage Structs
 */
class Markup extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Value and sold-in currency added by an airline as part of the offer reported as calculation detail.
     * @var \StructType\AmountType
     */
    public $Amount;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Defines the reason for the markup added by an airline as part of the offer reported as calculation detail. (Examples: currency markup, service markup, etc). | A code is a character string of letters, numbers, special characters
     * (except escape sequences), and symbols.
     * - base: xs:token
     * @var string
     */
    public $TypeCode;
    /**
     * Constructor method for Markup
     * @uses Markup::setAmount()
     * @uses Markup::setTypeCode()
     * @param \StructType\AmountType $amount
     * @param string $typeCode
     */
    public function __construct(\StructType\AmountType $amount = null, $typeCode = null)
    {
        $this
            ->setAmount($amount)
            ->setTypeCode($typeCode);
    }
    /**
     * Get Amount value
     * @return \StructType\AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\AmountType $amount
     * @return \StructType\Markup
     */
    public function setAmount(\StructType\AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\Markup
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
}
