<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingMessageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Marketing message: Additional, supplementary information about the document or service.
 * @subpackage Structs
 */
class MarketingMessageType extends AbstractStructBase
{
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\DescType
     */
    public $Desc;
    /**
     * The GeneralAssociation
     * Meta information extracted from the WSDL
     * - documentation: List the object intended to be associated within this message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GeneralAssociationType[]
     */
    public $GeneralAssociation;
    /**
     * Constructor method for MarketingMessageType
     * @uses MarketingMessageType::setDesc()
     * @uses MarketingMessageType::setGeneralAssociation()
     * @param \StructType\DescType $desc
     * @param \StructType\GeneralAssociationType[] $generalAssociation
     */
    public function __construct(\StructType\DescType $desc = null, array $generalAssociation = array())
    {
        $this
            ->setDesc($desc)
            ->setGeneralAssociation($generalAssociation);
    }
    /**
     * Get Desc value
     * @return \StructType\DescType
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param \StructType\DescType $desc
     * @return \StructType\MarketingMessageType
     */
    public function setDesc(\StructType\DescType $desc = null)
    {
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Get GeneralAssociation value
     * @return \StructType\GeneralAssociationType[]|null
     */
    public function getGeneralAssociation()
    {
        return $this->GeneralAssociation;
    }
    /**
     * This method is responsible for validating the values passed to the setGeneralAssociation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralAssociation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeneralAssociationForArrayConstraintsFromSetGeneralAssociation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $marketingMessageTypeGeneralAssociationItem) {
            // validation for constraint: itemType
            if (!$marketingMessageTypeGeneralAssociationItem instanceof \StructType\GeneralAssociationType) {
                $invalidValues[] = is_object($marketingMessageTypeGeneralAssociationItem) ? get_class($marketingMessageTypeGeneralAssociationItem) : sprintf('%s(%s)', gettype($marketingMessageTypeGeneralAssociationItem), var_export($marketingMessageTypeGeneralAssociationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeneralAssociation property can only contain items of type \StructType\GeneralAssociationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeneralAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\GeneralAssociationType[] $generalAssociation
     * @return \StructType\MarketingMessageType
     */
    public function setGeneralAssociation(array $generalAssociation = array())
    {
        // validation for constraint: array
        if ('' !== ($generalAssociationArrayErrorMessage = self::validateGeneralAssociationForArrayConstraintsFromSetGeneralAssociation($generalAssociation))) {
            throw new \InvalidArgumentException($generalAssociationArrayErrorMessage, __LINE__);
        }
        $this->GeneralAssociation = $generalAssociation;
        return $this;
    }
    /**
     * Add item to GeneralAssociation value
     * @throws \InvalidArgumentException
     * @param \StructType\GeneralAssociationType $item
     * @return \StructType\MarketingMessageType
     */
    public function addToGeneralAssociation(\StructType\GeneralAssociationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GeneralAssociationType) {
            throw new \InvalidArgumentException(sprintf('The GeneralAssociation property can only contain items of type \StructType\GeneralAssociationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeneralAssociation[] = $item;
        return $this;
    }
}
