<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarketingCarrierInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: A set of attributes of a marketed carrier used in search criteria
 * @subpackage Structs
 */
class MarketingCarrierInfoType extends AbstractStructBase
{
    /**
     * The CarrierDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code. | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes. {codeListAgencyName}IATA or
     * ICAO{/codeListAgencyName} {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | The codelist contents of IATA Resolution 762 airline codes, or of ICAO airline codes {codeListAgencyName}IATA or ICAO{/codeListAgencyName}
     * {codeListName}Resolution 762 Airline Codes or ICAO Airline Codes{/codeListName} | Either the IATA-defined 2-character code or the ICAO-defined 3-character code of an airline, as per the length of the value.
     * - base: AirlineDesigCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])
     * @var string
     */
    public $CarrierDesigCode;
    /**
     * The MarketingCarrierFlightNumberText
     * Meta information extracted from the WSDL
     * - documentation: The numerical designation of a flight as it is marketed by a carrier. | Identifies a flight number. 1 to 4 digits. May or may not have leading zeros when less than 4 digits. The use of leading zeros does not create a different Flight
     * Number. For example, Flight Numbers 123 and 0123 are the same.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{1,4}
     * @var string
     */
    public $MarketingCarrierFlightNumberText;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - documentation: Commercial name of the carrier. | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The OperationalSuffixText
     * Meta information extracted from the WSDL
     * - documentation: An Operational Suffix | Defines the Operational Suffix which is appended to a flight number.
     * - base: xs:string
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OperationalSuffixText;
    /**
     * The RBD_Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify a particular RBD (e.g. P, J, W, M, etc.). | Enumeration values of RBD Codes as per PADIS codeset 9800. {codeListAgencyName}IATA{/codeListAgencyName} {codeListIdentifier}PADIS 9800{/codeListIdentifier} |
     * Additional BDT to specify the RBD as defined in AIRIMP and SSIM.
     * - base: RBD_CodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RBD_Code;
    /**
     * Constructor method for MarketingCarrierInfoType
     * @uses MarketingCarrierInfoType::setCarrierDesigCode()
     * @uses MarketingCarrierInfoType::setMarketingCarrierFlightNumberText()
     * @uses MarketingCarrierInfoType::setCarrierName()
     * @uses MarketingCarrierInfoType::setOperationalSuffixText()
     * @uses MarketingCarrierInfoType::setRBD_Code()
     * @param string $carrierDesigCode
     * @param string $marketingCarrierFlightNumberText
     * @param string $carrierName
     * @param string $operationalSuffixText
     * @param string $rBD_Code
     */
    public function __construct($carrierDesigCode = null, $marketingCarrierFlightNumberText = null, $carrierName = null, $operationalSuffixText = null, $rBD_Code = null)
    {
        $this
            ->setCarrierDesigCode($carrierDesigCode)
            ->setMarketingCarrierFlightNumberText($marketingCarrierFlightNumberText)
            ->setCarrierName($carrierName)
            ->setOperationalSuffixText($operationalSuffixText)
            ->setRBD_Code($rBD_Code);
    }
    /**
     * Get CarrierDesigCode value
     * @return string
     */
    public function getCarrierDesigCode()
    {
        return $this->CarrierDesigCode;
    }
    /**
     * Set CarrierDesigCode value
     * @param string $carrierDesigCode
     * @return \StructType\MarketingCarrierInfoType
     */
    public function setCarrierDesigCode($carrierDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierDesigCode) && !is_string($carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierDesigCode, true), gettype($carrierDesigCode)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9]))
        if (!is_null($carrierDesigCode) && !preg_match('/([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])/', $carrierDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{3}|[A-Z]{2})|([0-9][A-Z])|([A-Z][0-9])', var_export($carrierDesigCode, true)), __LINE__);
        }
        $this->CarrierDesigCode = $carrierDesigCode;
        return $this;
    }
    /**
     * Get MarketingCarrierFlightNumberText value
     * @return string
     */
    public function getMarketingCarrierFlightNumberText()
    {
        return $this->MarketingCarrierFlightNumberText;
    }
    /**
     * Set MarketingCarrierFlightNumberText value
     * @param string $marketingCarrierFlightNumberText
     * @return \StructType\MarketingCarrierInfoType
     */
    public function setMarketingCarrierFlightNumberText($marketingCarrierFlightNumberText = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierFlightNumberText) && !is_string($marketingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierFlightNumberText, true), gettype($marketingCarrierFlightNumberText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,4})
        if (!is_null($marketingCarrierFlightNumberText) && !preg_match('/[0-9]{1,4}/', $marketingCarrierFlightNumberText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,4}', var_export($marketingCarrierFlightNumberText, true)), __LINE__);
        }
        $this->MarketingCarrierFlightNumberText = $marketingCarrierFlightNumberText;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\MarketingCarrierInfoType
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get OperationalSuffixText value
     * @return string|null
     */
    public function getOperationalSuffixText()
    {
        return $this->OperationalSuffixText;
    }
    /**
     * Set OperationalSuffixText value
     * @param string $operationalSuffixText
     * @return \StructType\MarketingCarrierInfoType
     */
    public function setOperationalSuffixText($operationalSuffixText = null)
    {
        // validation for constraint: string
        if (!is_null($operationalSuffixText) && !is_string($operationalSuffixText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationalSuffixText, true), gettype($operationalSuffixText)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($operationalSuffixText) && mb_strlen($operationalSuffixText) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($operationalSuffixText)), __LINE__);
        }
        $this->OperationalSuffixText = $operationalSuffixText;
        return $this;
    }
    /**
     * Get RBD_Code value
     * @return string|null
     */
    public function getRBD_Code()
    {
        return $this->RBD_Code;
    }
    /**
     * Set RBD_Code value
     * @param string $rBD_Code
     * @return \StructType\MarketingCarrierInfoType
     */
    public function setRBD_Code($rBD_Code = null)
    {
        // validation for constraint: string
        if (!is_null($rBD_Code) && !is_string($rBD_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rBD_Code, true), gettype($rBD_Code)), __LINE__);
        }
        $this->RBD_Code = $rBD_Code;
        return $this;
    }
}
