<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyProgramType StructType
 * Meta information extracted from the WSDL
 * - documentation: A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
 * @subpackage Structs
 */
class LoyaltyProgramType extends AbstractStructBase
{
    /**
     * The Alliance
     * Meta information extracted from the WSDL
     * - documentation: Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AllianceType
     */
    public $Alliance;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - documentation: The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc. Business Identifier Fields: - Airline
     * Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CarrierType
     */
    public $Carrier;
    /**
     * The ProgramCode
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program ID: Example: MAM | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramCode;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program Name. Example: Miles and More | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The ProviderName
     * Meta information extracted from the WSDL
     * - documentation: Name of the organization providing the Loyalty Program. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProviderName;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club | A string of characters used to identify a resource. Such identification enables interaction with representations of the
     * resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for LoyaltyProgramType
     * @uses LoyaltyProgramType::setAlliance()
     * @uses LoyaltyProgramType::setCarrier()
     * @uses LoyaltyProgramType::setProgramCode()
     * @uses LoyaltyProgramType::setProgramName()
     * @uses LoyaltyProgramType::setProviderName()
     * @uses LoyaltyProgramType::setURL()
     * @param \StructType\AllianceType $alliance
     * @param \StructType\CarrierType $carrier
     * @param string $programCode
     * @param string $programName
     * @param string $providerName
     * @param string $uRL
     */
    public function __construct(\StructType\AllianceType $alliance = null, \StructType\CarrierType $carrier = null, $programCode = null, $programName = null, $providerName = null, $uRL = null)
    {
        $this
            ->setAlliance($alliance)
            ->setCarrier($carrier)
            ->setProgramCode($programCode)
            ->setProgramName($programName)
            ->setProviderName($providerName)
            ->setURL($uRL);
    }
    /**
     * Get Alliance value
     * @return \StructType\AllianceType|null
     */
    public function getAlliance()
    {
        return $this->Alliance;
    }
    /**
     * Set Alliance value
     * @param \StructType\AllianceType $alliance
     * @return \StructType\LoyaltyProgramType
     */
    public function setAlliance(\StructType\AllianceType $alliance = null)
    {
        $this->Alliance = $alliance;
        return $this;
    }
    /**
     * Get Carrier value
     * @return \StructType\CarrierType|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param \StructType\CarrierType $carrier
     * @return \StructType\LoyaltyProgramType
     */
    public function setCarrier(\StructType\CarrierType $carrier = null)
    {
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \StructType\LoyaltyProgramType
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programCode, true), gettype($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\LoyaltyProgramType
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get ProviderName value
     * @return string|null
     */
    public function getProviderName()
    {
        return $this->ProviderName;
    }
    /**
     * Set ProviderName value
     * @param string $providerName
     * @return \StructType\LoyaltyProgramType
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerName, true), gettype($providerName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($providerName) && mb_strlen($providerName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($providerName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($providerName) && mb_strlen($providerName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($providerName)), __LINE__);
        }
        $this->ProviderName = $providerName;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\LoyaltyProgramType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
