<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegsAssociatedCabinType StructType
 * Meta information extracted from the WSDL
 * - documentation: An association of cabin types to 1 or more legs.
 * @subpackage Structs
 */
class LegsAssociatedCabinType extends AbstractStructBase
{
    /**
     * The DatedOperatingLegRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies a leg within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $DatedOperatingLegRefID;
    /**
     * The LegCabinType
     * Meta information extracted from the WSDL
     * - documentation: Type of compartment of an aircraft, offering specific services (e.g. business class, economy). Business Identifier Fields: - Cabin Type Code
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CabinTypeType
     */
    public $LegCabinType;
    /**
     * Constructor method for LegsAssociatedCabinType
     * @uses LegsAssociatedCabinType::setDatedOperatingLegRefID()
     * @uses LegsAssociatedCabinType::setLegCabinType()
     * @param string[] $datedOperatingLegRefID
     * @param \StructType\CabinTypeType $legCabinType
     */
    public function __construct(array $datedOperatingLegRefID = array(), \StructType\CabinTypeType $legCabinType = null)
    {
        $this
            ->setDatedOperatingLegRefID($datedOperatingLegRefID)
            ->setLegCabinType($legCabinType);
    }
    /**
     * Get DatedOperatingLegRefID value
     * @return string[]
     */
    public function getDatedOperatingLegRefID()
    {
        return $this->DatedOperatingLegRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $legsAssociatedCabinTypeDatedOperatingLegRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($legsAssociatedCabinTypeDatedOperatingLegRefIDItem)) {
                $invalidValues[] = is_object($legsAssociatedCabinTypeDatedOperatingLegRefIDItem) ? get_class($legsAssociatedCabinTypeDatedOperatingLegRefIDItem) : sprintf('%s(%s)', gettype($legsAssociatedCabinTypeDatedOperatingLegRefIDItem), var_export($legsAssociatedCabinTypeDatedOperatingLegRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string[] $datedOperatingLegRefID
     * @return \StructType\LegsAssociatedCabinType
     */
    public function setDatedOperatingLegRefID(array $datedOperatingLegRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegRefIDArrayErrorMessage = self::validateDatedOperatingLegRefIDForArrayConstraintsFromSetDatedOperatingLegRefID($datedOperatingLegRefID))) {
            throw new \InvalidArgumentException($datedOperatingLegRefIDArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegRefID = $datedOperatingLegRefID;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\LegsAssociatedCabinType
     */
    public function addToDatedOperatingLegRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegRefID[] = $item;
        return $this;
    }
    /**
     * Get LegCabinType value
     * @return \StructType\CabinTypeType
     */
    public function getLegCabinType()
    {
        return $this->LegCabinType;
    }
    /**
     * Set LegCabinType value
     * @param \StructType\CabinTypeType $legCabinType
     * @return \StructType\LegsAssociatedCabinType
     */
    public function setLegCabinType(\StructType\CabinTypeType $legCabinType = null)
    {
        $this->LegCabinType = $legCabinType;
        return $this;
    }
}
