<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Late StructType
 * @subpackage Structs
 */
class Late extends AbstractStructBase
{
    /**
     * The LatePercent
     * Meta information extracted from the WSDL
     * - documentation: Specific segment late %
     * @var string
     */
    public $LatePercent;
    /**
     * The MinutesLate
     * Meta information extracted from the WSDL
     * - documentation: Display number of minutes . Example : 60 minutes or more
     * @var string
     */
    public $MinutesLate;
    /**
     * Constructor method for Late
     * @uses Late::setLatePercent()
     * @uses Late::setMinutesLate()
     * @param string $latePercent
     * @param string $minutesLate
     */
    public function __construct($latePercent = null, $minutesLate = null)
    {
        $this
            ->setLatePercent($latePercent)
            ->setMinutesLate($minutesLate);
    }
    /**
     * Get LatePercent value
     * @return string|null
     */
    public function getLatePercent()
    {
        return $this->LatePercent;
    }
    /**
     * Set LatePercent value
     * @param string $latePercent
     * @return \StructType\Late
     */
    public function setLatePercent($latePercent = null)
    {
        // validation for constraint: string
        if (!is_null($latePercent) && !is_string($latePercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latePercent, true), gettype($latePercent)), __LINE__);
        }
        $this->LatePercent = $latePercent;
        return $this;
    }
    /**
     * Get MinutesLate value
     * @return string|null
     */
    public function getMinutesLate()
    {
        return $this->MinutesLate;
    }
    /**
     * Set MinutesLate value
     * @param string $minutesLate
     * @return \StructType\Late
     */
    public function setMinutesLate($minutesLate = null)
    {
        // validation for constraint: string
        if (!is_null($minutesLate) && !is_string($minutesLate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minutesLate, true), gettype($minutesLate)), __LINE__);
        }
        $this->MinutesLate = $minutesLate;
        return $this;
    }
}
