<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LangUsageType StructType
 * Meta information extracted from the WSDL
 * - documentation: Language Code representation.
 * @subpackage Structs
 */
class LangUsageType extends AbstractStructBase
{
    /**
     * The LangCode
     * Meta information extracted from the WSDL
     * - documentation: Language Code representation. Notes: 1. Language code. Example: en, en-US. 2. Encoding Schemes: ISO 639-1 Code OR Microsoft National Language Support (NLS) Code. 3. Supports ISO 639-1 (two alpha character) neutral language encoding
     * indicated by a name such as 'en' for English. 4. Supports MNLS geographically specific language encoding indicated by a name that includes both locale and country/region information. For example, the locale English (United States) has the language
     * name 'en-US'. | Language Code {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}Language Code{/codeListName} {codeListIdentifier}6392{/codeListIdentifier} | BDT to represent ISO language code list.
     * - base: LangCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LangCode;
    /**
     * The LangUsageText
     * Meta information extracted from the WSDL
     * - documentation: Written or Spoken language. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LangUsageText;
    /**
     * Constructor method for LangUsageType
     * @uses LangUsageType::setLangCode()
     * @uses LangUsageType::setLangUsageText()
     * @param string $langCode
     * @param string $langUsageText
     */
    public function __construct($langCode = null, $langUsageText = null)
    {
        $this
            ->setLangCode($langCode)
            ->setLangUsageText($langUsageText);
    }
    /**
     * Get LangCode value
     * @return string
     */
    public function getLangCode()
    {
        return $this->LangCode;
    }
    /**
     * Set LangCode value
     * @param string $langCode
     * @return \StructType\LangUsageType
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->LangCode = $langCode;
        return $this;
    }
    /**
     * Get LangUsageText value
     * @return string|null
     */
    public function getLangUsageText()
    {
        return $this->LangUsageText;
    }
    /**
     * Set LangUsageText value
     * @param string $langUsageText
     * @return \StructType\LangUsageType
     */
    public function setLangUsageText($langUsageText = null)
    {
        // validation for constraint: string
        if (!is_null($langUsageText) && !is_string($langUsageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langUsageText, true), gettype($langUsageText)), __LINE__);
        }
        $this->LangUsageText = $langUsageText;
        return $this;
    }
}
